/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JTable;
import weka.core.Instances;
import weka.gui.arffviewer.ArffPanel;

public class WekaInstancesDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 6791882185628220997L;
    protected ArffPanel m_ArffPanel;

    public String globalInfo() {
        return "Actor for displaying a weka.core.Instances object in table format.";
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    protected Instances createDummyDataset() {
        return new Instances("Empty", new ArrayList(), 0);
    }

    public void clearPanel() {
        if (this.m_ArffPanel != null) {
            this.m_ArffPanel.setInstances(this.createDummyDataset());
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_ArffPanel = new ArffPanel(this.createDummyDataset());
        result.add((Component)this.m_ArffPanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected void display(Token token) {
        this.m_ArffPanel.setInstances((Instances)token.getPayload());
    }

    protected String doExecute() {
        String result = null;
        if (this.isHeadless()) {
            System.out.println("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n");
            System.out.println(this.m_InputToken.getPayload());
        } else {
            result = super.doExecute();
        }
        return result;
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_ArffPanel != null) {
            this.m_ArffPanel.setInstances(this.createDummyDataset());
        }
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("ARFF file", "arff");
    }

    public String supplyText() {
        if (this.m_ArffPanel != null) {
            return this.m_ArffPanel.getInstances().toString();
        }
        return null;
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 7384093089760722339L;
            protected ArffPanel m_ArffPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_ArffPanel = new ArffPanel(new Instances("Dummy", new ArrayList(), 0));
                this.add((Component)this.m_ArffPanel, "Center");
            }

            public void display(Token token) {
                this.m_ArffPanel.setInstances((Instances)token.getPayload());
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("ARFF file", "arff");
            }

            public String supplyText() {
                return this.m_ArffPanel.getInstances().toString();
            }

            public void clearPanel() {
            }

            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public Class[] getSendToClasses() {
        ArrayList<Class> result = new ArrayList<Class>(Arrays.asList(super.getSendToClasses()));
        if (!result.contains(JTable.class)) {
            result.add(JTable.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        result = SendToActionUtils.isAvailable(JTable.class, (Class[])cls) ? this.m_ArffPanel.getTable() : super.getSendToItem(cls);
        return result;
    }
}

