/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.base.AttributeTypeList;
import adams.core.base.BaseList;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.AbstractSimpleSource;
import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.unsupervised.attribute.AddValues;
import weka.filters.unsupervised.attribute.ChangeDateFormat;

public class WekaNewInstances
extends AbstractSimpleSource
implements ProvenanceSupporter {
    private static final long serialVersionUID = 1862828539481494711L;
    public static final String ATTRIBUTE_PREFIX = "att-";
    public static final String DEFAULT_CLASS = "class";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    protected AttributeTypeList m_AttributeTypes;
    protected BaseList m_AttributeNames;
    protected Index m_ClassIndex;
    protected String m_ClassName;
    protected String m_RelationName;

    public String globalInfo() {
        return "Generates an empty dataset, based on the attribute types and names specified.\nNominal attributes are generated with an empty set of labels. Use the " + AddValues.class.getName() + " filter to add the required labels.\n" + "Date attributes are created with the default format of '" + DEFAULT_DATE_FORMAT + "'. " + "Use the " + ChangeDateFormat.class.getName() + " filter to change the " + "format to a more suitable format, if required.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("relation-name", "relationName", (Object)"");
        this.m_OptionManager.add("att-type", "attributeTypes", (Object)new AttributeTypeList());
        this.m_OptionManager.add("att-name", "attributeNames", (Object)new BaseList());
        this.m_OptionManager.add("class-index", "classIndex", (Object)"");
        this.m_OptionManager.add("class-name", "className", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassIndex = new Index();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"relationName", (Object)(this.m_RelationName.length() == 0 ? "<actor name>" : this.m_RelationName), (String)"relation: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"attributeTypes", (Object)this.m_AttributeTypes.listValue().length, (String)", # atts: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)(this.m_ClassIndex.getIndex().length() == 0 ? "-none-" : this.m_ClassIndex), (String)", class: ");
        return result;
    }

    public void setRelationName(String value) {
        this.m_RelationName = value;
        this.reset();
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return "The name of the relation; if left empty, the full name of the actor is used.";
    }

    public void setAttributeTypes(AttributeTypeList value) {
        this.m_AttributeTypes = value;
        this.reset();
    }

    public AttributeTypeList getAttributeTypes() {
        return this.m_AttributeTypes;
    }

    public String attributeTypesTipText() {
        return this.m_AttributeTypes.getTipText();
    }

    public void setAttributeNames(BaseList value) {
        this.m_AttributeNames = value;
        this.reset();
    }

    public BaseList getAttributeNames() {
        return this.m_AttributeNames;
    }

    public String attributeNamesTipText() {
        return "The comma-separated list of attribute names; if left empty or not enough items available, the prefix 'att-' is used in conjunction with the 1-based index of the attribute; for the class attribute (if applicable), the name 'class' is used, unless otherwise specified.";
    }

    public void setClassIndex(String value) {
        this.m_ClassIndex.setIndex(value);
        this.reset();
    }

    public String getClassIndex() {
        return this.m_ClassIndex.getIndex();
    }

    public String classIndexTipText() {
        return "The class index to set, leave empty to have none set; " + this.m_ClassIndex.getExample();
    }

    public void setClassName(String value) {
        this.m_ClassName = value;
        this.reset();
    }

    public String getClassName() {
        return this.m_ClassName;
    }

    public String classNameTipText() {
        return "The name of the class attribute; default is 'class'.";
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_OutputToken = null;
        try {
            String name;
            String[] types = this.m_AttributeTypes.listValue();
            String[] names = this.m_AttributeNames.listValue();
            this.m_ClassIndex.setMax(types.length);
            int index = this.m_ClassIndex.getIntIndex();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (int i = 0; i < types.length; ++i) {
                Attribute att;
                name = i >= names.length ? (i == index ? (this.m_ClassName.length() == 0 ? DEFAULT_CLASS : this.m_ClassName) : ATTRIBUTE_PREFIX + (i + 1)) : names[i];
                if (types[i].equals("NUM")) {
                    att = new Attribute(name);
                } else if (types[i].equals("NOM")) {
                    att = new Attribute(name, new ArrayList());
                } else if (types[i].equals("STR")) {
                    att = new Attribute(name, (List)null);
                } else if (types[i].equals("DAT")) {
                    att = new Attribute(name, DEFAULT_DATE_FORMAT);
                } else {
                    throw new IllegalStateException("Unhandled attribute type: " + types[i]);
                }
                atts.add(att);
            }
            name = this.m_RelationName.length() == 0 ? this.getFullName() : this.m_RelationName;
            Instances data = new Instances(name, atts, 0);
            data.setClassIndex(index);
            this.m_OutputToken = new Token((Object)data);
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        catch (Exception e) {
            result = this.handleException("Failed to create new dataset: ", e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

