/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.WekaSelectDatasetPage;
import adams.gui.wizard.WekaSelectMultipleDatasetsPage;
import adams.gui.wizard.WizardPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;

public class AppendDatasets
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = 7586443345167287461L;

    public AppendDatasets() {
        this(null);
    }

    public AppendDatasets(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getIconName() {
        return "append.png";
    }

    public void launch() {
        final WizardPane wizard = new WizardPane();
        wizard.setCustomFinishText("Append");
        WekaSelectMultipleDatasetsPage infiles = new WekaSelectMultipleDatasetsPage("Input");
        infiles.setDescription("Select the Weka datasets to append (one-after-the-other).\nYou have to choose at least two.");
        infiles.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    return files.length >= 2;
                }
                catch (Exception e) {
                    AppendDatasets.this.getLogger().log(Level.SEVERE, "Failed to obtain files:", e);
                    return false;
                }
            }
        });
        wizard.addPage((AbstractWizardPage)infiles);
        WekaSelectDatasetPage outfile = new WekaSelectDatasetPage("Output");
        outfile.setDescription("Select the file to save the combined data to.");
        outfile.setUseSaveDialog(true);
        wizard.addPage((AbstractWizardPage)outfile);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Ready</h2>Please click on <b>Append</b> to start the process.</html>");
        wizard.addPage((AbstractWizardPage)finalpage);
        final ChildFrame frame = this.createChildFrame((Component)wizard, 800, 600);
        wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!e.getActionCommand().equals("Finish")) {
                    frame.dispose();
                    return;
                }
                Properties props = wizard.getProperties(false);
                File[] input = null;
                File output = null;
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    input = new File[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        input[i] = new File(files[i]);
                    }
                    output = new File(props.getProperty("file"));
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage((Component)AppendDatasets.this.getOwner(), (String)("Failed to get setup from wizard!\n" + Utils.throwableToString((Throwable)ex)));
                    return;
                }
                AppendDatasets.this.doAppend(frame, input, output);
            }
        });
    }

    protected void doAppend(ChildFrame frame, File[] input, File output) {
        int i;
        if (input.length < 2) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)"At least two files are required!");
            return;
        }
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)input[0]);
        Instances[] data = new Instances[input.length];
        int count = 0;
        for (i = 0; i < input.length; ++i) {
            try {
                loader.setFile(input[i]);
                data[i] = ConverterUtils.DataSource.read((Loader)loader);
                if (i > 0 && !data[0].equalHeaders(data[i])) {
                    GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Datasets '" + input[0] + "' and '" + input[i] + "' are not compatible!\n" + data[0].equalHeadersMsg(data[i])));
                    return;
                }
                count += data[i].numInstances();
                continue;
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to read '" + input[i] + "'!\n" + Utils.throwableToString((Throwable)e)));
                return;
            }
        }
        Instances full = new Instances(data[0], count);
        for (i = 0; i < data.length; ++i) {
            for (Instance inst : data[i]) {
                full.add(inst);
            }
        }
        try {
            ConverterUtils.DataSink sink = new ConverterUtils.DataSink(output.getAbsolutePath());
            sink.write(full);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Failed to save data to '" + output + "'!\n" + Utils.throwableToString((Throwable)e)));
            return;
        }
        GUIHelper.showInformationMessage(null, (String)("Successfully apended!\n" + output));
        frame.dispose();
    }

    public String getTitle() {
        return "Append datasets";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    public String getCategory() {
        return "Tools";
    }
}

