/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.menu.AbstractParameterHandlingWekaMenuItemDefinition;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.filechooser.FileFilter;

public class GraphVisualizer
extends AbstractParameterHandlingWekaMenuItemDefinition {
    private static final long serialVersionUID = -771667287275117680L;
    protected BaseFileChooser m_FileChooser;

    public GraphVisualizer() {
        this(null);
    }

    public GraphVisualizer(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser(new File(System.getProperty("user.dir")));
        this.m_FileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("XML BIF file", "xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        weka.gui.graphvisualizer.GraphVisualizer panel;
        FileInputStream stream;
        FileReader reader;
        String filename;
        block8: {
            if (this.m_Parameters.length == 0) {
                int retVal = this.m_FileChooser.showOpenDialog(null);
                if (retVal != 0) {
                    return;
                }
                filename = this.m_FileChooser.getSelectedFile().getAbsolutePath();
            } else {
                filename = new PlaceholderFile(this.m_Parameters[0]).getAbsolutePath();
            }
            reader = null;
            stream = null;
            panel = new weka.gui.graphvisualizer.GraphVisualizer();
            try {
                if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                    stream = new FileInputStream(filename);
                    panel.readBIF((InputStream)stream);
                    break block8;
                }
                reader = new FileReader(filename);
                panel.readDOT((Reader)reader);
            }
            catch (Exception e) {
                try {
                    GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Error loading file '" + filename + "':\n" + Utils.throwableToString((Throwable)e)));
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(reader);
                    FileUtils.closeQuietly(stream);
                    throw throwable;
                }
                FileUtils.closeQuietly((Reader)reader);
                FileUtils.closeQuietly((InputStream)stream);
                return;
            }
        }
        FileUtils.closeQuietly((Reader)reader);
        FileUtils.closeQuietly((InputStream)stream);
        ChildFrame frame = this.createChildFrame((Component)panel, 800, 600);
        frame.setTitle(frame.getTitle() + " - " + filename);
    }

    public String getTitle() {
        return "Graph visualizer";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    @Override
    public String getCategory() {
        return "Visualization";
    }
}

