/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.gui.tools.previewbrowser.AbstractSerializedObjectViewer;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.classifiers.bayes.BayesNet;
import weka.core.Drawable;

public class GraphVisualizer
extends AbstractSerializedObjectViewer {
    private static final long serialVersionUID = -262735238228366027L;

    public String globalInfo() {
        return "Display graphs from " + BayesNet.class.getName() + " models.";
    }

    public boolean handles(Object obj) {
        return obj instanceof Drawable && ((Drawable)obj).graphType() == 2;
    }

    protected PreviewPanel createPreview(Object obj) {
        String bif;
        try {
            bif = ((Drawable)obj).graph();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to obtain BIF graph:", e);
            bif = null;
        }
        if (bif == null) {
            return null;
        }
        weka.gui.graphvisualizer.GraphVisualizer panel = new weka.gui.graphvisualizer.GraphVisualizer();
        try {
            panel.readBIF(bif);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to parse BIF graph:", e);
            panel = null;
        }
        if (panel == null) {
            return null;
        }
        return new PreviewPanel((JComponent)panel);
    }
}

