/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class AndrewsCurves
extends SimpleStreamFilter
implements TechnicalInformationHandler,
UnsupervisedFilter {
    private static final long serialVersionUID = 2244583826137735498L;
    protected int m_NumPoints = 100;

    public String globalInfo() {
        return "Generates Andrews Curves from array data.\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.AUTHOR, "C\u00e9sar Ignacio Garc\u00eda Osorio and Colin Fyfe");
        result.setValue(TechnicalInformation.Field.TITLE, "AN EXTENSION OF ANDREWS CURVES FOR DATA ANALYSIS");
        result.setValue(TechnicalInformation.Field.HTTP, "http://cib.uco.es/documents/Garcia03SIGEF.pdf");
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe number of points to generate (> 0).\n\t(default: 100)", "num-points", 1, "-num-points <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"num-points", (String[])options);
        if (tmpStr.length() > 0) {
            this.setNumPoints(Integer.parseInt(tmpStr));
        } else {
            this.setNumPoints(100);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-num-points");
        result.add("" + this.getNumPoints());
        return result.toArray(new String[result.size()]);
    }

    public void setNumPoints(int value) {
        if (value > 0) {
            this.m_NumPoints = value;
            this.reset();
        } else {
            System.err.println("The number of points to the left must be > 0 (provided: " + value + ")!");
        }
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points to generate, > 0.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        boolean hasClass = inputFormat.classIndex() > -1;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < this.m_NumPoints; ++i) {
            atts.add(new Attribute("att" + (i + 1)));
        }
        if (hasClass) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (hasClass) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        int i;
        boolean hasClass = instance.classIndex() > -1;
        TDoubleArrayList values = new TDoubleArrayList();
        for (i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            values.add(instance.value(i));
        }
        TDoubleArrayList valuesNew = new TDoubleArrayList();
        for (i = 0; i < this.m_NumPoints; ++i) {
            double t = -Math.PI + Math.PI * 2 / (double)this.m_NumPoints * (double)i;
            double y = values.get(0) / Math.sqrt(2.0);
            for (int n = 1; n < values.size(); ++n) {
                if ((n + 1) % 2 == 0) {
                    y += values.get(n) * Math.sin(t * Math.ceil(n / 2));
                    continue;
                }
                y += values.get(n) * Math.cos(t * Math.ceil(n / 2));
            }
            valuesNew.add(y);
        }
        if (hasClass) {
            valuesNew.add(instance.classValue());
        }
        DenseInstance result = new DenseInstance(instance.weight(), valuesNew.toArray());
        result.setDataset(this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        AndrewsCurves.runFilter((Filter)new AndrewsCurves(), (String[])args);
    }
}

