/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import adams.core.io.FileUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import weka.gui.visualize.plugins.GraphVisualizePlugin;

public class SaveGraph
implements GraphVisualizePlugin {
    public JMenuItem getVisualizeMenuItem(final String bif, String name) {
        ExtensionFileFilter filter = new ExtensionFileFilter("XML BIF", new String[]{"xml"});
        final BaseFileChooser chooser = new BaseFileChooser();
        chooser.setDialogTitle("Save graoh - " + name);
        chooser.addChoosableFileFilter((FileFilter)filter);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setDefaultExtension("xml");
        chooser.setFileFilter((FileFilter)filter);
        JMenuItem result = new JMenuItem("Save graph...");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = chooser.showSaveDialog(null);
                if (retVal != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                if (!FileUtils.writeToFile((String)file.getAbsolutePath(), (Object)bif, (boolean)false)) {
                    GUIHelper.showErrorMessage(null, (String)("Failed to save graph as " + file + "!"));
                }
            }
        });
        return result;
    }

    public String getMinVersion() {
        return "3.5.9";
    }

    public String getMaxVersion() {
        return "3.8.0";
    }

    public String getDesignVersion() {
        return "3.6.0";
    }
}

