/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.WekaExperimentFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.SequenceToArray;
import adams.flow.transformer.WekaExperiment;
import adams.flow.transformer.WekaExperimentEvaluation;
import adams.test.TmpExperimentFile;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixCSV;

public class WekaExperimentTest
extends AbstractFlowTest {
    public WekaExperimentTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("experiment.xml");
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("experiment.xml");
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        FileUtils.delete((String)"./out.arff");
        super.tearDown();
    }

    public Actor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/vote.arff"), new BaseString("${TMP}/labor.arff")});
        SequenceToArray s2a = new SequenceToArray();
        s2a.setArrayLength(2);
        WekaExperiment exp = new WekaExperiment();
        exp.setExperimentFile((WekaExperimentFile)new TmpExperimentFile("experiment.xml"));
        WekaExperimentEvaluation eval = new WekaExperimentEvaluation();
        eval.setOutputFormat((ResultMatrix)new ResultMatrixCSV());
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{sc, s2a, exp, eval, df});
        return flow;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[]{6};
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.csv"));
    }

    public static Test suite() {
        return new TestSuite(WekaExperimentTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaExperimentTest.runTest((Test)WekaExperimentTest.suite());
    }
}

