/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilterWithLoadings;

public class PLSFilterWithLoadingsTest
extends AbstractAdamsFilterTest {
    protected static final int NUM_ATTS = 5;
    protected static final int NUM_NUMERIC_ATTS = 20;

    public PLSFilterWithLoadingsTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return this.getFilter(5, 2);
    }

    public Filter getFilter(int numAtts, int algorithm) {
        PLSFilterWithLoadings filter = new PLSFilterWithLoadings();
        filter.setNumComponents(numAtts);
        filter.setReplaceMissing(true);
        filter.setPreprocessing(new SelectedTag(1, PLSFilterWithLoadings.TAGS_PREPROCESSING));
        filter.setAlgorithm(new SelectedTag(algorithm, PLSFilterWithLoadings.TAGS_ALGORITHM));
        return filter;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        Instances result = test.generate();
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        this.m_Instances = test.generate();
    }

    protected void performTest(int algorithm) {
        Instances icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter(5, algorithm);
        Instances result = this.useFilter();
        PLSFilterWithLoadingsTest.assertEquals((int)result.numAttributes(), (int)6);
        PLSFilterWithLoadingsTest.assertEquals((int)result.numInstances(), (int)icopy.numInstances());
        this.m_Filter = this.getFilter(10, algorithm);
        result = this.useFilter();
        PLSFilterWithLoadingsTest.assertEquals((int)result.numAttributes(), (int)11);
        PLSFilterWithLoadingsTest.assertEquals((int)result.numInstances(), (int)icopy.numInstances());
    }

    public void testPLS1() {
        this.performTest(2);
    }

    public void testSIMPLS() {
        this.performTest(1);
    }

    public static Test suite() {
        return new TestSuite(PLSFilterWithLoadingsTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)PLSFilterWithLoadingsTest.suite());
    }
}

