/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.M5P;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Scale;
import weka.test.AdamsTestHelper;

public class ScaleTest
extends AbstractAdamsFilterTest {
    public ScaleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter(this.getFilter());
        result.setClassifier((Classifier)new M5P());
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(0);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return new Scale();
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ScaleTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            ScaleTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ScaleTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        ScaleTest.assertEquals((int)result.numAttributes(), (int)this.m_Instances.numAttributes());
        ScaleTest.assertEquals((int)result.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(ScaleTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)ScaleTest.suite());
    }
}

