/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.ReportToWekaInstance;
import adams.data.instance.Instance;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.env.Environment;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class ReportToWekaInstanceTest
extends AbstractConversionTestCase {
    public ReportToWekaInstanceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("bolts.arff");
        try {
            Instances data = ConverterUtils.DataSource.read((String)file.getAbsolutePath());
            data.setClassIndex(data.numAttributes() - 1);
            result = new Report[data.numInstances()];
            for (int i = 0; i < data.numInstances(); ++i) {
                Instance inst = new Instance();
                inst.set(data.instance(i), i, new int[0], new Range("first-last"), null);
                result[i] = inst.getReport();
            }
        }
        catch (Exception e) {
            result = new Report[]{};
            ReportToWekaInstanceTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        ReportToWekaInstance[] result = new ReportToWekaInstance[]{new ReportToWekaInstance()};
        result[0].setFields(new Field[]{new Field("Class", DataType.NUMERIC), new Field("Dataset-Row", DataType.NUMERIC), new Field("Dataset-Name", DataType.STRING)});
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(ReportToWekaInstanceTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ReportToWekaInstanceTest.runTest((Test)ReportToWekaInstanceTest.suite());
    }
}

