/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.WekaExperimentGenerator;
import adams.flow.source.WekaClassifierGenerator;
import adams.test.Platform;
import adams.test.TmpFile;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaExperimentGeneratorTest
extends AbstractFlowTest {
    public WekaExperimentGeneratorTest(String name) {
        super(name);
    }

    protected HashSet<Platform> getPlatforms() {
        return new HashSet<Platform>(Arrays.asList(Platform.LINUX));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile_cv.xml");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_rsr.xml");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_rsop.xml");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile_cv.xml");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_rsr.xml");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_rsop.xml");
        super.tearDown();
    }

    public Actor getActor() {
        WekaClassifierGenerator cg = new WekaClassifierGenerator();
        cg.setOutputArray(true);
        WekaExperimentGenerator eg_cv = new WekaExperimentGenerator();
        eg_cv.setExperimentType(WekaExperimentGenerator.ExperimentType.REGRESSION);
        eg_cv.setEvaluationType(WekaExperimentGenerator.EvaluationType.CROSS_VALIDATION);
        eg_cv.setRuns(9);
        eg_cv.setFolds(5);
        eg_cv.setResultFormat(WekaExperimentGenerator.ResultFormat.ARFF);
        eg_cv.setResultFile((PlaceholderFile)new TmpFile("dumpfile_cv.arff"));
        eg_cv.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_cv.xml"));
        WekaExperimentGenerator eg_rsr = new WekaExperimentGenerator();
        eg_rsr.setExperimentType(WekaExperimentGenerator.ExperimentType.REGRESSION);
        eg_rsr.setEvaluationType(WekaExperimentGenerator.EvaluationType.TRAIN_TEST_SPLIT_RANDOMIZED);
        eg_rsr.setRuns(8);
        eg_rsr.setSplitPercentage(50.0);
        eg_rsr.setResultFormat(WekaExperimentGenerator.ResultFormat.CSV);
        eg_rsr.setResultFile((PlaceholderFile)new TmpFile("dumpfile_rsr.csv"));
        eg_rsr.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_rsr.xml"));
        WekaExperimentGenerator eg_rsop = new WekaExperimentGenerator();
        eg_rsop.setExperimentType(WekaExperimentGenerator.ExperimentType.REGRESSION);
        eg_rsop.setEvaluationType(WekaExperimentGenerator.EvaluationType.TRAIN_TEST_SPLIT_ORDER_PRESERVED);
        eg_rsop.setRuns(7);
        eg_rsop.setSplitPercentage(75.0);
        eg_rsop.setResultFormat(WekaExperimentGenerator.ResultFormat.ARFF);
        eg_rsop.setResultFile((PlaceholderFile)new TmpFile("dumpfile_rsop.arff"));
        eg_rsop.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_rsop.xml"));
        Branch br = new Branch();
        br.setNumThreads(1);
        br.setBranches(new Actor[]{eg_cv, eg_rsr, eg_rsop});
        Flow flow = new Flow();
        flow.setActors(new Actor[]{cg, br});
        return flow;
    }

    public void testRegression() {
    }

    public static Test suite() {
        return new TestSuite(WekaExperimentGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaExperimentGeneratorTest.runTest((Test)WekaExperimentGeneratorTest.suite());
    }
}

