/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model.clustering;

import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.env.Environment;
import adams.ml.data.Dataset;
import adams.ml.model.clustering.AbstractClustererTestCase;
import adams.ml.model.clustering.Clusterer;
import adams.ml.model.clustering.WekaClusterer;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.clusterers.SimpleKMeans;

public class WekaClustererTest
extends AbstractClustererTestCase {
    public WekaClustererTest(String name) {
        super(name);
    }

    protected Clusterer getTypicalSetup() {
        WekaClusterer result = new WekaClusterer();
        SimpleKMeans simple = new SimpleKMeans();
        try {
            simple.setNumClusters(3);
        }
        catch (Exception e) {
            WekaClustererTest.fail((String)"Failed to set the number of clusters!");
        }
        result.setClusterer((weka.clusterers.Clusterer)simple);
        return result;
    }

    protected Dataset getTypicalDataset() {
        return this.load("iris_no_class.csv", (SpreadSheetReader)new CsvSpreadSheetReader());
    }

    protected String[] getRegressionInputFiles() {
        return new String[]{"iris_no_class.csv"};
    }

    protected SpreadSheetReader[] getRegressionInputReaders() {
        return new SpreadSheetReader[]{new CsvSpreadSheetReader()};
    }

    protected Clusterer[] getRegressionSetups() {
        WekaClusterer[] result = new WekaClusterer[]{new WekaClusterer()};
        SimpleKMeans simple = new SimpleKMeans();
        try {
            simple.setNumClusters(3);
        }
        catch (Exception e) {
            WekaClustererTest.fail((String)"Failed to set the number of clusters!");
        }
        result[0].setClusterer((weka.clusterers.Clusterer)simple);
        return result;
    }

    public static Test suite() {
        return new TestSuite(WekaClustererTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClustererTest.runTest((Test)WekaClustererTest.suite());
    }
}

