/*
 * Decompiled with CFR 0.152.
 */
package adams.tools;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.test.TmpFile;
import adams.tools.AbstractTool;
import adams.tools.AbstractToolTestCase;
import adams.tools.CompareDatasets;

public class CompareDatasetsTest
extends AbstractToolTestCase {
    public CompareDatasetsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris_1.arff");
        this.m_TestHelper.copyResourceToTmp("iris_2.arff");
        this.m_TestHelper.deleteFileFromTmp("missing.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris_1.arff");
        this.m_TestHelper.deleteFileFromTmp("iris_2.arff");
        this.m_TestHelper.deleteFileFromTmp("missing.csv");
        super.tearDown();
    }

    protected String[] getRegressionInputFiles() {
        return new String[0];
    }

    protected String[] getRegressionOutputFiles() {
        return new String[]{"out1.csv", "out2.csv", "out3.csv", "out4.csv"};
    }

    protected AbstractTool[] getRegressionSetups() {
        CompareDatasets[] result = new CompareDatasets[4];
        result[0] = new CompareDatasets();
        result[0].setDataset1((PlaceholderFile)new TmpFile("iris_1.arff"));
        result[0].setDataset2((PlaceholderFile)new TmpFile("iris_2.arff"));
        result[0].setMissing((PlaceholderFile)new TmpFile("missing.csv"));
        result[1] = new CompareDatasets();
        result[1].setDataset1((PlaceholderFile)new TmpFile("iris_1.arff"));
        result[1].setDataset2((PlaceholderFile)new TmpFile("iris_2.arff"));
        result[1].setRange1(new Range("2-last"));
        result[1].setRange2(new Range("2-last"));
        result[1].setMissing((PlaceholderFile)new TmpFile("missing.csv"));
        result[2] = new CompareDatasets();
        result[2].setDataset1((PlaceholderFile)new TmpFile("iris_1.arff"));
        result[2].setDataset2((PlaceholderFile)new TmpFile("iris_2.arff"));
        result[2].setRange1(new Range("2"));
        result[2].setRange2(new Range("2"));
        result[2].setMissing((PlaceholderFile)new TmpFile("missing.csv"));
        result[3] = new CompareDatasets();
        result[3].setDataset1((PlaceholderFile)new TmpFile("iris_1.arff"));
        result[3].setDataset2((PlaceholderFile)new TmpFile("iris_2.arff"));
        result[3].setMissing((PlaceholderFile)new TmpFile("missing.csv"));
        result[3].setThreshold(1.0);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }
}

