/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import adams.core.base.BaseRegExp;
import adams.data.instancesanalysis.pls.AbstractPLS;
import adams.data.instancesanalysis.pls.PLS1;
import adams.data.instancesanalysis.pls.PreprocessingType;
import adams.data.instancesanalysis.pls.SIMPLS;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegressionJ;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.MultiPLS;

public class MultiPLSTest
extends AbstractAdamsFilterTest {
    protected static final int NUM_ATTS = 5;
    protected static final int NUM_NUMERIC_ATTS = 20;

    public MultiPLSTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return this.getFilter(5, (AbstractPLS)new PLS1());
    }

    public Filter getFilter(int numAtts, AbstractPLS algorithm) {
        MultiPLS filter = new MultiPLS();
        algorithm.setNumComponents(numAtts);
        algorithm.setNumComponents(numAtts);
        algorithm.setReplaceMissing(true);
        algorithm.setPreprocessingType(PreprocessingType.CENTER);
        filter.setAlgorithm(algorithm);
        filter.setXRegExp(new BaseRegExp("Numeric.*"));
        filter.setYRegExp(new BaseRegExp("Class.*"));
        return filter;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        Instances result = test.generate();
        return result;
    }

    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        Filter filter = this.getFilter();
        result.setFilter(filter);
        result.setClassifier((Classifier)new LinearRegressionJ());
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        this.m_Instances = test.generate();
    }

    protected void performTest(AbstractPLS algorithm) {
        Instances icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter(5, algorithm);
        Instances result = this.useFilter();
        MultiPLSTest.assertEquals((int)result.numInstances(), (int)icopy.numInstances());
        this.m_Filter = this.getFilter(10, algorithm);
        result = this.useFilter();
        MultiPLSTest.assertEquals((int)result.numInstances(), (int)icopy.numInstances());
    }

    public void testMultiPLS1() {
        this.performTest((AbstractPLS)new PLS1());
    }

    public void testSIMPLS() {
        this.performTest((AbstractPLS)new SIMPLS());
    }

    public static Test suite() {
        return new TestSuite(MultiPLSTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiPLSTest.suite());
    }
}

