/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassLocator;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.Conversion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import weka.core.OptionHandler;
import weka.core.Utils;

public class WekaCommandLineHandler
extends AbstractCommandLineHandler {
    private static final long serialVersionUID = -5233496867185402778L;

    public Object fromCommandLine(String cmd) {
        Object result;
        try {
            result = this.fromArray(Utils.splitOptions((String)cmd));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to process commandline '" + cmd + "':", (Throwable)e);
            result = null;
        }
        return result;
    }

    public Object fromArray(String[] args) {
        Object result = null;
        if ((args = (String[])args.clone()).length > 0) {
            try {
                String classname = args[0];
                args[0] = "";
                result = Utils.forName(Object.class, (String)Conversion.getSingleton().rename(classname), (String[])args);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to instantiate object from array (fromArray):", (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public String toCommandLine(Object obj) {
        StringBuilder result = new StringBuilder();
        result.append(obj.getClass().getName());
        if (obj instanceof OptionHandler) {
            result.append(" ");
            result.append(Utils.joinOptions((String[])((OptionHandler)obj).getOptions()));
        }
        return result.toString().trim();
    }

    public String toShortCommandLine(Object obj) {
        StringBuilder result = new StringBuilder();
        result.append(obj.getClass().getSimpleName());
        if (obj instanceof OptionHandler) {
            result.append(" ");
            result.append(Utils.joinOptions((String[])((OptionHandler)obj).getOptions()));
        }
        return result.toString().trim();
    }

    public String[] toArray(Object obj) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(obj.getClass().getName());
        if (obj instanceof OptionHandler) {
            result.addAll(Arrays.asList(((OptionHandler)obj).getOptions()));
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getOptions(Object obj) {
        return ((OptionHandler)obj).getOptions();
    }

    public boolean setOptions(Object obj, String[] args) {
        boolean result;
        try {
            ((OptionHandler)obj).setOptions((String[])args.clone());
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public String[] splitOptions(String cmdline) {
        String[] result;
        try {
            result = Utils.splitOptions((String)cmdline);
        }
        catch (Exception e) {
            result = new String[]{};
        }
        return result;
    }

    public String joinOptions(String[] args) {
        return Utils.joinOptions((String[])args);
    }

    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(OptionHandler.class, (Class)cls);
    }
}

