/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis;

import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.instancesanalysis.AbstractInstancesAnalysis;
import adams.data.instancesanalysis.pls.AbstractPLS;
import adams.data.instancesanalysis.pls.SIMPLS;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.weka.WekaAttributeRange;
import weka.core.Instances;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class PLS
extends AbstractInstancesAnalysis {
    private static final long serialVersionUID = 7150143741822676345L;
    protected WekaAttributeRange m_AttributeRange;
    protected AbstractPLS m_Algorithm;
    protected SpreadSheet m_Loadings;
    protected SpreadSheet m_Scores;

    public String globalInfo() {
        return "Performs principal components analysis and allows access to loadings and scores.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("attribute-range", "attributeRange", (Object)new WekaAttributeRange("first-last"));
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new SIMPLS());
    }

    protected void reset() {
        super.reset();
        this.m_Loadings = null;
        this.m_Scores = null;
    }

    public void setAttributeRange(WekaAttributeRange value) {
        this.m_AttributeRange = value;
        this.reset();
    }

    public WekaAttributeRange getAttributeRange() {
        return this.m_AttributeRange;
    }

    public String attributeRangeTipText() {
        return "The range of attributes to process.";
    }

    public void setAlgorithm(AbstractPLS value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractPLS getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The algorithm to use.";
    }

    protected void check(Instances data) {
        super.check((Object)data);
        this.m_AttributeRange.setData(data);
        if (this.m_AttributeRange.getIntIndices().length == 0) {
            throw new IllegalStateException("No attributes selected with range: " + this.m_AttributeRange.getRange());
        }
    }

    protected String doAnalyze(Instances data) throws Exception {
        this.m_Loadings = null;
        this.m_Scores = null;
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (!this.m_AttributeRange.isAllRange()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Filtering attribute range: " + this.m_AttributeRange.getRange());
            }
            Remove remove = new Remove();
            remove.setAttributeIndicesArray(this.m_AttributeRange.getIntIndices());
            remove.setInvertSelection(true);
            remove.setInputFormat(data);
            data = Filter.useFilter((Instances)data, (Filter)remove);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Performing PLS...");
        }
        weka.filters.supervised.attribute.PLS pls = new weka.filters.supervised.attribute.PLS();
        pls.setAlgorithm(this.m_Algorithm);
        pls.setInputFormat(data);
        data = Filter.useFilter((Instances)data, (Filter)pls);
        WekaInstancesToSpreadSheet conv = new WekaInstancesToSpreadSheet();
        conv.setInput(data);
        String result = conv.convert();
        if (result == null) {
            int i;
            SpreadSheet transformed = (SpreadSheet)conv.getOutput();
            Matrix matrix = pls.getLoadings();
            DefaultSpreadSheet loadings = new DefaultSpreadSheet();
            for (i = 0; i < matrix.getColumnDimension(); ++i) {
                loadings.getHeaderRow().addCell("L-" + (i + 1)).setContentAsString("Loading-" + (i + 1));
            }
            for (int n = 0; n < matrix.getRowDimension(); ++n) {
                DataRow row = loadings.addRow();
                for (i = 0; i < matrix.getColumnDimension(); ++i) {
                    row.addCell("L-" + (i + 1)).setContent(Double.valueOf(matrix.get(n, i)));
                }
            }
            this.m_Loadings = loadings;
            this.m_Scores = transformed;
        }
        return result;
    }

    public SpreadSheet getLoadings() {
        return this.m_Loadings;
    }

    public SpreadSheet getScores() {
        return this.m_Scores;
    }
}

