/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.AbstractOptionHandler;
import adams.data.instancesanalysis.pls.PredictionType;
import adams.data.instancesanalysis.pls.PreprocessingType;
import java.util.HashMap;
import java.util.Map;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.GenericPLSMatrixAccess;
import weka.core.Instances;
import weka.core.matrix.Matrix;

public abstract class AbstractPLS
extends AbstractOptionHandler
implements CapabilitiesHandler,
TechnicalInformationHandler,
GenericPLSMatrixAccess {
    private static final long serialVersionUID = -2619191840396410446L;
    protected boolean m_Initialized;
    protected PreprocessingType m_PreprocessingType;
    protected boolean m_ReplaceMissing;
    protected int m_NumComponents;
    protected PredictionType m_PredictionType;
    protected Instances m_OutputFormat;

    public abstract TechnicalInformation getTechnicalInformation();

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preprocessing-type", "preprocessingType", (Object)PreprocessingType.CENTER);
        this.m_OptionManager.add("replace-missing", "replaceMissing", (Object)false);
        this.m_OptionManager.add("num-components", "numComponents", (Object)20, (Number)1, null);
        this.m_OptionManager.add("prediction-type", "predictionType", (Object)PredictionType.NONE);
    }

    public void setPreprocessingType(PreprocessingType value) {
        this.m_PreprocessingType = value;
        this.reset();
    }

    public PreprocessingType getPreprocessingType() {
        return this.m_PreprocessingType;
    }

    public String preprocessingTypeTipText() {
        return "The type of preprocessing to perform.";
    }

    public void setReplaceMissing(boolean value) {
        this.m_ReplaceMissing = value;
        this.reset();
    }

    public boolean getReplaceMissing() {
        return this.m_ReplaceMissing;
    }

    public String replaceMissingTipText() {
        return "Whether to replace missing values.";
    }

    public void setNumComponents(int value) {
        this.m_NumComponents = value;
        this.reset();
    }

    public int getNumComponents() {
        return this.m_NumComponents;
    }

    public String numComponentsTipText() {
        return "The number of components to compute.";
    }

    public void setPredictionType(PredictionType value) {
        this.m_PredictionType = value;
    }

    public PredictionType getPredictionType() {
        return this.m_PredictionType;
    }

    public String predictionTypeTipText() {
        return "The type of prediction to perform.";
    }

    public void reset() {
        super.reset();
        this.m_Initialized = false;
        this.m_OutputFormat = null;
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        return result;
    }

    @Override
    public abstract String[] getMatrixNames();

    @Override
    public abstract Matrix getMatrix(String var1);

    @Override
    public abstract boolean hasLoadings();

    @Override
    public abstract Matrix getLoadings();

    public boolean isInitialized() {
        return this.m_Initialized;
    }

    public abstract Instances determineOutputFormat(Instances var1) throws Exception;

    public Instances getOutputFormat() {
        return this.m_OutputFormat;
    }

    protected abstract Instances preTransform(Instances var1, Map<String, Object> var2) throws Exception;

    protected abstract Instances doTransform(Instances var1, Map<String, Object> var2) throws Exception;

    protected abstract Instances postTransform(Instances var1, Map<String, Object> var2) throws Exception;

    public Instances transform(Instances data) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Instances result = this.preTransform(data, params);
        result = this.doTransform(result, params);
        result = this.postTransform(result, params);
        this.m_Initialized = true;
        return result;
    }
}

