/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.instance.Instance;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.instance.AbstractInstancePaintlet;
import adams.gui.visualization.instance.AbstractInstancePanelUpdater;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstanceLinePaintlet;
import adams.gui.visualization.instance.InstancePanel;
import adams.gui.visualization.instance.SimpleInstancePanelUpdater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import weka.core.Attribute;
import weka.core.Instances;

public class WekaInstanceViewer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 1283926389472133810L;
    protected InstancePanel m_InstancePanel;
    protected AbstractColorProvider m_ColorProvider;
    protected AbstractInstancePaintlet m_Paintlet;
    protected boolean m_ZoomOverview;
    protected String m_ID;
    protected AbstractInstancePanelUpdater m_Updater;

    public String globalInfo() {
        return "Actor for displaying adams.data.instance.Instance objects in a graphical way (using the internal format), like the 'Instance Explorer' tool.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new InstanceLinePaintlet());
        this.m_OptionManager.add("zoom-overview", "zoomOverview", (Object)false);
        this.m_OptionManager.add("id", "ID", (Object)"");
        this.m_OptionManager.add("updater", "updater", (Object)new SimpleInstancePanelUpdater());
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 500;
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider in use for coloring the instances.";
    }

    public void setPaintlet(AbstractInstancePaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public AbstractInstancePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for drawing the instances.";
    }

    public void setZoomOverview(boolean value) {
        this.m_ZoomOverview = value;
        this.reset();
    }

    public boolean getZoomOverview() {
        return this.m_ZoomOverview;
    }

    public String zoomOverviewTipText() {
        return "If enabled, a zoom overview panel gets displayed as well.";
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The name of the attribute/field to use as the ID in the display.";
    }

    public void setUpdater(AbstractInstancePanelUpdater value) {
        this.m_Updater = value;
        this.reset();
    }

    public AbstractInstancePanelUpdater getUpdater() {
        return this.m_Updater;
    }

    public String updaterTipText() {
        return "The updater in use for updating the visualization.";
    }

    public void clearPanel() {
        if (this.m_InstancePanel != null) {
            ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_InstancePanel = new InstancePanel();
        this.m_InstancePanel.setZoomOverviewPanelVisible(this.m_ZoomOverview);
        ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).setColorProvider(this.m_ColorProvider.shallowCopy(true));
        this.m_InstancePanel.setDataPaintlet(this.m_Paintlet.shallowCopy(true));
        result.add((Component)((Object)this.m_InstancePanel), (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{weka.core.Instance.class, Instance.class};
    }

    protected void display(Token token) {
        Instance inst;
        if (token.getPayload() instanceof weka.core.Instance) {
            Attribute att;
            weka.core.Instance winst = (weka.core.Instance)token.getPayload();
            inst = new Instance();
            inst.set(winst);
            if (!this.m_ID.isEmpty() && (att = winst.dataset().attribute(this.m_ID)) != null) {
                String id = att.isNominal() || att.isString() ? winst.stringValue(att.index()) : "" + winst.value(att.index());
                inst.setID(id);
            }
        } else {
            inst = (Instance)((Object)token.getPayload());
            if (inst.hasReport() && inst.getReport().hasValue(this.m_ID)) {
                inst.setID("" + inst.getReport().getValue((AbstractField)new Field(this.m_ID, DataType.UNKNOWN)));
            }
        }
        InstanceContainerManager manager = (InstanceContainerManager)this.m_InstancePanel.getContainerManager();
        InstanceContainer cont = manager.newContainer((Comparable)((Object)inst));
        manager.startUpdate();
        manager.add(cont);
        this.m_Updater.update((DataContainerPanel)this.m_InstancePanel, (Object)cont);
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_InstancePanel != null) {
            ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
        }
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -5618543590920864397L;
            protected InstancePanel m_InstancePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_InstancePanel = new InstancePanel();
                this.add((Component)((Object)this.m_InstancePanel), "Center");
            }

            public void display(Token token) {
                Instance inst = null;
                if (token.getPayload() instanceof weka.core.Instance) {
                    inst = new Instance();
                    inst.set((weka.core.Instance)token.getPayload());
                } else {
                    inst = (Instance)((Object)token.getPayload());
                }
                InstanceContainerManager manager = (InstanceContainerManager)this.m_InstancePanel.getContainerManager();
                InstanceContainer cont = manager.newContainer((Comparable)((Object)inst));
                manager.add(cont);
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("ARFF file", "arff");
            }

            public String supplyText() {
                return WekaInstanceViewer.supplyText(this.m_InstancePanel);
            }

            public void clearPanel() {
                ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
            }

            public void cleanUp() {
                ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public String getCustomSupplyTextMenuItemCaption() {
        return "Save instances as...";
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("ARFF file", "arff");
    }

    public String supplyText() {
        return WekaInstanceViewer.supplyText(this.m_InstancePanel);
    }

    protected static String supplyText(InstancePanel panel) {
        if (panel == null) {
            return null;
        }
        InstanceContainerManager manager = (InstanceContainerManager)panel.getContainerManager();
        if (manager.countVisible() == 0) {
            return null;
        }
        Instances data = new Instances(manager.getVisible(0).getData().getDatasetHeader());
        for (int i = 0; i < manager.countVisible(); ++i) {
            data.add(manager.getVisible(i).getData().toInstance());
        }
        return data.toString();
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }

    public void wrapUp() {
        if (this.m_Panel != null) {
            this.m_Updater.update((DataContainerPanel)this.m_InstancePanel);
        }
        super.wrapUp();
    }
}

