/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.core.io.ConsoleHelper;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.SearchPanel;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.InstancesTableModel;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JTable;
import weka.core.Instances;

public class WekaInstancesDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 6791882185628220997L;
    protected InstancesTable m_Table;

    public String globalInfo() {
        return "Actor for displaying a weka.core.Instances object in table format.";
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void clearPanel() {
        if (this.m_Table != null) {
            this.m_Table.setInstances(null);
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_Table = new InstancesTable(new InstancesTableModel());
        result.add((Component)new BaseScrollPane((Component)((Object)this.m_Table)), (Object)"Center");
        SearchPanel searchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        searchPanel.addSearchListener(e -> this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
        result.add((Component)searchPanel, (Object)"South");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected void display(Token token) {
        this.m_Table.setInstances((Instances)token.getPayload());
    }

    protected String doExecute() {
        String result = null;
        if (this.isHeadless()) {
            ConsoleHelper.printlnOut((String)("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n"));
            ConsoleHelper.printlnOut((String)("" + this.m_InputToken.getPayload()));
        } else {
            result = super.doExecute();
        }
        return result;
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_Table != null) {
            this.m_Table.setInstances(null);
        }
    }

    public String getCustomSupplyTextMenuItemCaption() {
        return "Save instances as...";
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("ARFF file", "arff");
    }

    public String supplyText() {
        if (this.m_Table != null) {
            return this.m_Table.getInstances().toString();
        }
        return null;
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 7384093089760722339L;
            protected InstancesTable m_Table;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_Table = new InstancesTable(new InstancesTableModel());
                this.add((Component)new BaseScrollPane((Component)((Object)this.m_Table)), "Center");
                SearchPanel searchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
                searchPanel.addSearchListener(e -> this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
            }

            public void display(Token token) {
                this.m_Table.setInstances((Instances)token.getPayload());
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("ARFF file", "arff");
            }

            public String supplyText() {
                return this.m_Table.getInstances().toString();
            }

            public void clearPanel() {
            }

            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public Class[] getSendToClasses() {
        ArrayList<Class> result = new ArrayList<Class>(Arrays.asList(super.getSendToClasses()));
        if (!result.contains(JTable.class)) {
            result.add(JTable.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        result = SendToActionUtils.isAvailable(JTable.class, (Class[])cls) ? this.m_Table : super.getSendToItem(cls);
        return result;
    }
}

