/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;

public class WekaClustererSetup
extends AbstractSimpleSource {
    private static final long serialVersionUID = 4936805424766023527L;
    protected Clusterer m_Clusterer;

    public String globalInfo() {
        return "Outputs an instance of the specified clusterer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("clusterer", "clusterer", (Object)new SimpleKMeans());
    }

    public void setClusterer(Clusterer value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The Weka clusterer to build on the input data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"clusterer", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.m_Clusterer), (int)40));
    }

    public Class[] generates() {
        return new Class[]{Clusterer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Clusterer cls = AbstractClusterer.makeCopy((Clusterer)this.m_Clusterer);
            this.m_OutputToken = new Token((Object)cls);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of clusterer:", e);
        }
        return result;
    }
}

