/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.VariableName;
import adams.core.base.BaseRegExp;
import adams.flow.control.Trigger;
import adams.flow.core.Actor;
import adams.flow.source.Variable;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.transformer.SetVariable;
import adams.flow.transformer.StringReplace;
import adams.flow.transformer.WekaInstanceDumper;

public class InstanceDumperVariable
extends AbstractActorTemplate {
    private static final long serialVersionUID = 2310015199489870240L;
    protected VariableName m_VariableName;

    public String globalInfo() {
        return "Generates a sub-flow that sets a variable for the " + WekaInstanceDumper.class.getName() + " transformer's outputPrefix property using a prefix based on the full flow name. In other words, the ARFF/CSV file will get generated in the same location as the flow.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable", "variableName", (Object)new VariableName());
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to be used for the 'outputPrefix' property.";
    }

    protected Actor doGenerate() {
        Trigger result = new Trigger();
        result.setName("Setting variable '" + this.m_VariableName + "'");
        Variable var = new Variable();
        var.setVariableName(new VariableName("flow_filename_long"));
        result.add((Actor)var);
        StringReplace replace = new StringReplace();
        replace.setFind(new BaseRegExp("\\.[^\\.]*"));
        result.add((Actor)replace);
        SetVariable setVar = new SetVariable();
        setVar.setVariableName(this.m_VariableName);
        result.add((Actor)setVar);
        return result;
    }
}

