/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.classifiers.AggregateableEvaluation;
import weka.classifiers.Evaluation;

public class WekaAggregateEvaluations
extends AbstractTransformer {
    private static final long serialVersionUID = 3799673803958040769L;
    public static final String BACKUP_EVALUATION = "evaluation";
    protected AggregateableEvaluation m_Evaluation;

    public String globalInfo() {
        return "Aggregates incoming " + Evaluation.class.getName() + " objects and forwards the current aggregated state.";
    }

    protected void reset() {
        super.reset();
        this.m_Evaluation = null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_EVALUATION);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_EVALUATION, this.m_Evaluation);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_EVALUATION)) {
            this.m_Evaluation = (AggregateableEvaluation)state.get(BACKUP_EVALUATION);
            state.remove(BACKUP_EVALUATION);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    public Class[] generates() {
        return new Class[]{WekaEvaluationContainer.class};
    }

    protected String doExecute() {
        String result = null;
        Evaluation input = this.m_InputToken.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (Evaluation)this.m_InputToken.getPayload();
        try {
            if (this.m_Evaluation == null) {
                this.m_Evaluation = new AggregateableEvaluation(input);
            }
            this.m_Evaluation.aggregate(input);
            this.m_OutputToken = new Token((Object)this.m_Evaluation);
        }
        catch (Exception e) {
            result = this.handleException("Failed to aggregate evaluation!", e);
        }
        return result;
    }
}

