/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Pausable;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.event.CatSwarmOptimizationFitnessChangeEvent;
import adams.event.CatSwarmOptimizationFitnessChangeListener;
import adams.event.FlowPauseStateEvent;
import adams.event.FlowPauseStateListener;
import adams.event.VariableChangeListener;
import adams.flow.container.WekaCatSwarmOptimizationContainer;
import adams.flow.container.WekaGeneticAlgorithmContainer;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.ErrorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.OptionalCallableActor;
import adams.flow.core.PauseStateHandler;
import adams.flow.core.PauseStateManager;
import adams.flow.core.Token;
import adams.flow.standalone.JobRunnerSetup;
import adams.flow.transformer.AbstractTransformer;
import adams.opt.cso.AbstractJobBasedCatSwarmOptimization;
import adams.opt.cso.ClassifierBasedCatSwarmOptimization;
import adams.opt.cso.HermioneSimple;
import java.util.HashSet;
import java.util.Hashtable;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class WekaCatSwarmOptimization
extends AbstractTransformer
implements CatSwarmOptimizationFitnessChangeListener,
CallableActorUser,
OptionalCallableActor,
FlowPauseStateListener,
Pausable {
    private static final long serialVersionUID = 5071747277597147724L;
    public static final String BACKUP_CALLABLEACTOR = "callable actor";
    public static final String BACKUP_CONFIGURED = "configured";
    protected ClassifierBasedCatSwarmOptimization m_Algorithm;
    protected transient ClassifierBasedCatSwarmOptimization m_ActualAlgorithm;
    protected CallableActorReference m_CallableName;
    protected Actor m_CallableActor;
    protected boolean m_Configured;
    protected CallableActorHelper m_Helper;
    protected boolean m_Optional;
    protected PauseStateManager m_PauseStateManager;
    protected transient JobRunnerSetup m_JobRunnerSetup;

    public String globalInfo() {
        return "Applies the cat swarm optimization (CSO) algorithm to the incoming dataset.\nForwards the best setup after the algorithm finishes.\nA callable sink can be specified for receiving intermediate performance results.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new HermioneSimple());
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("optional", "optional", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
        this.m_Configured = false;
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)this.m_Algorithm, (String)"algorithm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName, (String)", callable: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"optional", (boolean)this.m_Optional, (String)"optional", (String)", ");
        return result;
    }

    public void setAlgorithm(ClassifierBasedCatSwarmOptimization value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public ClassifierBasedCatSwarmOptimization getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The swarm algorithm to apply to the dataset.";
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable sink to forward to the " + WekaGeneticAlgorithmContainer.class.getName() + " containers.";
    }

    public void setOptional(boolean value) {
        this.m_Optional = value;
        this.reset();
    }

    public boolean getOptional() {
        return this.m_Optional;
    }

    public String optionalTipText() {
        return "If enabled, then the callable sink is optional, ie no error is raised if not found, merely ignored.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaGeneticAlgorithmContainer.class};
    }

    protected Actor findCallableActor() {
        Actor result = this.m_Helper.findCallableActorRecursive((Actor)this, this.getCallableName());
        if (result != null && !ActorUtils.isSink((Actor)result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a sink" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    public Actor getCallableActor() {
        return this.m_CallableActor;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CALLABLEACTOR);
        this.pruneBackup(BACKUP_CONFIGURED);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_CallableActor != null) {
            result.put(BACKUP_CALLABLEACTOR, this.m_CallableActor);
        }
        result.put(BACKUP_CONFIGURED, this.m_Configured);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CALLABLEACTOR)) {
            this.m_CallableActor = (Actor)state.get(BACKUP_CALLABLEACTOR);
            state.remove(BACKUP_CALLABLEACTOR);
        }
        if (state.containsKey(BACKUP_CONFIGURED)) {
            this.m_Configured = (Boolean)state.get(BACKUP_CONFIGURED);
            state.remove(BACKUP_CONFIGURED);
        }
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_CallableActor = this.findCallableActor();
        this.m_Configured = true;
        if (this.m_CallableActor == null) {
            if (!this.m_Optional) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else {
                this.getLogger().info("Callable actor '" + this.getCallableName() + "' not found, ignoring.");
            }
        } else {
            HashSet variables = this.findVariables(this.m_CallableActor);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener((VariableChangeListener)this);
            }
            if (this.getErrorHandler() != this) {
                ActorUtils.updateErrorHandler((Actor)this.m_CallableActor, (ErrorHandler)this.getErrorHandler(), (boolean)this.isLoggingEnabled());
            }
        }
        return result;
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("callableName")) == null) {
            result = this.setUpCallableActor();
        }
        if (this.getRoot() instanceof PauseStateHandler) {
            this.m_PauseStateManager = ((PauseStateHandler)this.getRoot()).getPauseStateManager();
            if (this.m_PauseStateManager != null) {
                this.m_PauseStateManager.addListener((FlowPauseStateListener)this);
            }
        } else {
            this.m_PauseStateManager = null;
        }
        if (result == null) {
            this.m_JobRunnerSetup = (JobRunnerSetup)ActorUtils.findClosestType((Actor)this, JobRunnerSetup.class);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Instances data = (Instances)this.m_InputToken.getPayload();
        WekaCatSwarmOptimizationContainer cont = null;
        this.m_ActualAlgorithm = (ClassifierBasedCatSwarmOptimization)OptionUtils.shallowCopy((Object)this.m_Algorithm);
        this.m_ActualAlgorithm.addFitnessChangeListener(this);
        if (this.m_ActualAlgorithm instanceof AbstractJobBasedCatSwarmOptimization) {
            ((AbstractJobBasedCatSwarmOptimization)this.m_ActualAlgorithm).setJobRunnerSetup(this.m_JobRunnerSetup);
            ((AbstractJobBasedCatSwarmOptimization)this.m_ActualAlgorithm).setFlowContext((Actor)this);
        }
        try {
            this.m_ActualAlgorithm.setInstances(data);
            this.m_ActualAlgorithm.run();
            if (this.m_ActualAlgorithm.isStopped()) {
                result = "Swarm algorithm stopped!";
            } else {
                cont = new WekaCatSwarmOptimizationContainer(this.m_ActualAlgorithm.getBestSetup(), this.m_ActualAlgorithm.getMeasure(), this.m_ActualAlgorithm.getCurrentFitness());
            }
            this.m_ActualAlgorithm.removeFitnessChangeListener(this);
            this.m_ActualAlgorithm = null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to run swarm algorithm!", e);
        }
        if (cont != null) {
            this.m_OutputToken = new Token(cont);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_PauseStateManager != null && this.m_PauseStateManager.isPaused()) {
            this.m_PauseStateManager.resume((Actor)this);
        }
        if (this.m_ActualAlgorithm != null) {
            this.m_ActualAlgorithm.removeFitnessChangeListener(this);
            this.m_ActualAlgorithm.stopExecution();
        }
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fitnessChanged(CatSwarmOptimizationFitnessChangeEvent e) {
        String result = null;
        if (!this.m_Configured) {
            result = this.setUpCallableActor();
        }
        if (result == null && this.m_CallableActor != null) {
            WekaCatSwarmOptimizationContainer cont = new WekaCatSwarmOptimizationContainer((Classifier)e.getSetup(), ((ClassifierBasedCatSwarmOptimization)e.getCatSwarmOptimization()).getMeasure(), e.getFitness());
            if (!this.m_CallableActor.getSkip() && !this.m_CallableActor.isStopped()) {
                Actor actor = this.m_CallableActor;
                synchronized (actor) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable sink - start: " + this.m_CallableActor);
                    }
                    ((InputConsumer)this.m_CallableActor).input(new Token((Object)cont));
                    result = this.m_CallableActor.execute();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable sink - end: " + result);
                    }
                }
            }
        }
    }

    public void pauseExecution() {
        if (this.m_PauseStateManager != null) {
            this.m_PauseStateManager.pause((Actor)this);
        }
    }

    public boolean isPaused() {
        if (this.m_PauseStateManager != null) {
            return this.m_PauseStateManager.isPaused();
        }
        return false;
    }

    public void resumeExecution() {
        if (this.m_PauseStateManager != null) {
            this.m_PauseStateManager.resume((Actor)this);
        }
    }

    public void flowPauseStateChanged(FlowPauseStateEvent e) {
        if (this.m_ActualAlgorithm != null) {
            switch (e.getType()) {
                case PAUSED: {
                    this.m_ActualAlgorithm.pauseExecution();
                    break;
                }
                case RESUMED: {
                    this.m_ActualAlgorithm.resumeExecution();
                }
            }
        }
    }
}

