/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractInteractiveTransformer;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTable;
import adams.gui.core.BaseTextArea;
import adams.gui.dialog.ApprovalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class WekaChooseAttributes
extends AbstractInteractiveTransformer
implements AutomatableInteractiveActor,
ProvenanceSupporter {
    private static final long serialVersionUID = -1483735876005865608L;
    protected String m_Message;
    protected BaseRegExp m_PreSelection;
    protected boolean m_NonInteractive;
    protected Remove m_Remove;

    public String globalInfo() {
        return "Lets the user select attributes interactively to use down the track.\nInternally, a " + Remove.class.getName() + " WEKA filter is constructed from the selection, to remove the attributes that the user didn't select.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", (Object)"Choose attributes to use");
        this.m_OptionManager.add("pre-selection", "preSelection", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("non-interactive", "nonInteractive", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Remove = new Remove();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"preSelection", (BaseRegExp)this.m_PreSelection);
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow if canceled"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"nonInteractive", (boolean)this.m_NonInteractive, (String)"non-interactive"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to display to the user (variables get expanded).";
    }

    public void setPreSelection(BaseRegExp value) {
        this.m_PreSelection = value;
        this.reset();
    }

    public BaseRegExp isPreSelection() {
        return this.m_PreSelection;
    }

    public String preSelectionTipText() {
        return "The regular expression to use for pre-selecting attributes.";
    }

    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    public String nonInteractiveTipText() {
        return "If enabled, attributes that match the 'pre-selection' pattern get selected automatically.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected List<Integer> selectAttributes(Instances inst, List<Integer> preSelected) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String msg = this.getVariables().expand(this.m_Message);
        int numAtts = inst.numAttributes();
        if (inst.classIndex() > -1) {
            --numAtts;
        }
        Object[][] names = new String[numAtts][1];
        int n = 0;
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (inst.classIndex() == i) continue;
            names[n][0] = inst.attribute(i).name();
            ++n;
        }
        DefaultTableModel model = new DefaultTableModel(names, new String[]{"Attribute"});
        Range range = new Range();
        range.setMax(numAtts);
        range.setIndices(Utils.toIntArray(preSelected));
        int[][] segments = range.getIntSegments();
        BaseTable table = new BaseTable((TableModel)model);
        table.setAutoResizeMode(0);
        table.setOptimalColumnWidth();
        table.setSelectionMode(2);
        for (int[] segment : segments) {
            table.getSelectionModel().addSelectionInterval(segment[0], segment[1]);
        }
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.add((Component)new BaseScrollPane((Component)table), "Center");
        if (msg.trim().length() > 0) {
            BaseTextArea textMessage = new BaseTextArea(msg.split("\n").length + 1, 40);
            textMessage.setText(msg);
            panelAll.add((Component)new BaseScrollPane((Component)textMessage), "North");
        }
        JPanel panelOptions = new JPanel(new FlowLayout(0));
        JCheckBox checkBoxInvert = new JCheckBox("Remove selected attributes rather than keep them");
        panelOptions.add(checkBoxInvert);
        panelAll.add((Component)panelOptions, "South");
        ApprovalDialog dialog = new ApprovalDialog(null, Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle("Choose attributes");
        dialog.getContentPane().add((Component)panelAll, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(this.getParentComponent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        if (checkBoxInvert.isSelected()) {
            range.setIndices(table.getSelectedRows());
            range.setInverted(true);
            result.addAll(Utils.toList((int[])range.getIntIndices()));
        } else {
            result.addAll(Utils.toList((int[])table.getSelectedRows()));
        }
        return result;
    }

    protected List<Integer> getPreSelectedIndices(Instances inst) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (inst.classIndex() == i || !this.m_PreSelection.isMatch(inst.attribute(i).name())) continue;
            result.add(i);
        }
        return result;
    }

    protected Instances filter(Instances inst, List<Integer> selected) throws Exception {
        this.m_Remove.setInvertSelection(true);
        this.m_Remove.setAttributeIndicesArray(Utils.toIntArray(selected));
        this.m_Remove.setInputFormat(inst);
        Instances result = Filter.useFilter((Instances)inst, (Filter)this.m_Remove);
        return result;
    }

    protected boolean generateOutput(Instances inst, List<Integer> selected) {
        boolean result;
        try {
            this.m_OutputToken = new Token((Object)this.filter(inst, selected));
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.handleException("Failed to remove attributes: " + OptionUtils.getCommandLine((Object)this.m_Remove), e);
        }
        return result;
    }

    public boolean doInteract() {
        boolean result = true;
        Instances inst = (Instances)this.m_InputToken.getPayload();
        List<Integer> selected = this.getPreSelectedIndices(inst);
        if (!this.m_NonInteractive) {
            boolean bl = result = (selected = this.selectAttributes(inst, selected)) != null;
        }
        if (result) {
            result = this.generateOutput(inst, selected);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.isHeadless()) {
            Instances inst = (Instances)this.m_InputToken.getPayload();
            if (!this.generateOutput(inst, this.getPreSelectedIndices(inst))) {
                result = "Failed to generate subset!";
            }
        } else {
            result = super.doExecute();
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), OptionUtils.getOptions((Object)this.m_Remove), this.m_OutputToken.getPayload().getClass()));
        }
    }
}

