/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.instance.Instance;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractWekaInstanceAndWekaInstancesTransformer;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Instances;

public class WekaClassSelector
extends AbstractWekaInstanceAndWekaInstancesTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    protected Index m_ClassIndex;
    protected boolean m_Override;
    protected BaseRegExp m_RegexName;
    protected boolean m_Unset;

    public String globalInfo() {
        return "Sets the class index. Can either honour an already existing one or override it. Also, one can apply the index on a subset of attributes defined by a regular expression applied to the attribute names (one can set the class index to the last attribute that starts with 'att_').";
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassIndex = new Index();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("class", "classIndex", (Object)new Index("last"));
        this.m_OptionManager.add("override", "override", (Object)false);
        this.m_OptionManager.add("regex", "regexName", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("unset", "unset", (Object)false);
    }

    public String getQuickInfo() {
        String result;
        if (this.m_Unset || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"unset")) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"unset", (boolean)this.m_Unset, (String)"unset");
        } else {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)this.m_ClassIndex);
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"override", (boolean)this.m_Override, (String)"override", (String)", ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regexName", (BaseRegExp)this.m_RegexName, (String)", name: ");
        }
        return result;
    }

    public void setClassIndex(Index value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public Index getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The index within the attribute subset defined by the regular expression ('first' and 'last' are accepted as well).";
    }

    public void setOverride(boolean value) {
        this.m_Override = value;
        this.reset();
    }

    public boolean getOverride() {
        return this.m_Override;
    }

    public String overrideTipText() {
        return "If set to true, then any existing class index will be overriden; otherwise the class index will only be set if not already set.";
    }

    public void setRegexName(BaseRegExp value) {
        this.m_RegexName = value;
        this.reset();
    }

    public BaseRegExp getRegexName() {
        return this.m_RegexName;
    }

    public String regexNameTipText() {
        return "The regular expression used for selecting the subset of attributes.";
    }

    public void setUnset(boolean value) {
        this.m_Unset = value;
        this.reset();
    }

    public boolean getUnset() {
        return this.m_Unset;
    }

    public String unsetTipText() {
        return "Unsets the class attribute.";
    }

    protected String doExecute() {
        String result = null;
        Object o = this.m_InputToken.getPayload();
        boolean isInstances = false;
        Instances inst = null;
        if (o instanceof Instances) {
            inst = (Instances)o;
            inst = new Instances(inst);
            isInstances = true;
        } else if (o instanceof Instance) {
            inst = ((Instance)((Object)o)).getDatasetHeader();
        } else if (o instanceof weka.core.Instance) {
            inst = ((weka.core.Instance)o).dataset();
        } else {
            result = "Cannot handle object of type " + o.getClass().getName() + "!";
        }
        if (result == null) {
            if (this.m_Unset) {
                inst.setClassIndex(-1);
            } else {
                ArrayList<Attribute> atts = new ArrayList<Attribute>();
                for (int i = 0; i < inst.numAttributes(); ++i) {
                    if (!this.m_RegexName.isEmpty() && !this.m_RegexName.isMatch(inst.attribute(i).name())) continue;
                    atts.add(inst.attribute(i));
                }
                this.m_ClassIndex.setMax(atts.size());
                if (this.m_Override || inst.classIndex() == -1) {
                    inst.setClassIndex(((Attribute)atts.get(this.m_ClassIndex.getIntIndex())).index());
                }
            }
            this.m_OutputToken = isInstances ? new Token((Object)inst) : new Token(o);
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

