/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Classifier;
import weka.core.PLSMatrixAccess;
import weka.core.matrix.Matrix;
import weka.filters.Filter;

public class WekaExtractPLSMatrix
extends AbstractTransformer {
    private static final long serialVersionUID = -7107032132240547550L;
    protected MatrixType m_MatrixType;

    public String globalInfo() {
        return "Transformer that allows the extraction of internal PLS filter/classifier matrices, forwarding them as spreadsheets.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("matrix-type", "matrixType", (Object)MatrixType.PLS1_P);
    }

    public void setMatrixType(MatrixType value) {
        this.m_MatrixType = value;
        this.reset();
    }

    public MatrixType getMatrixType() {
        return this.m_MatrixType;
    }

    public String matrixTypeTipText() {
        return "The type of matrix to extract, either PLS1 or SIMPLS will be available.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"matrixType", (Object)((Object)this.m_MatrixType));
    }

    public Class[] accepts() {
        return new Class[]{Classifier.class, Filter.class, PLSMatrixAccess.class, WekaModelContainer.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected SpreadSheet matrixToSpreadSheet(Matrix matrix, String colPrefix) {
        DefaultSpreadSheet result = null;
        if (matrix != null) {
            int i;
            result = new DefaultSpreadSheet();
            HeaderRow row = result.getHeaderRow();
            for (i = 0; i < matrix.getColumnDimension(); ++i) {
                row.addCell("" + i).setContent(colPrefix + (i + 1));
            }
            for (int n = 0; n < matrix.getRowDimension(); ++n) {
                row = result.addRow();
                for (i = 0; i < matrix.getColumnDimension(); ++i) {
                    row.addCell("" + i).setContent(Double.valueOf(matrix.get(n, i)));
                }
            }
        }
        return result;
    }

    protected SpreadSheet getMatrix(Classifier classifier) {
        if (classifier instanceof PLSMatrixAccess) {
            return this.getMatrix((PLSMatrixAccess)classifier);
        }
        return null;
    }

    protected SpreadSheet getMatrix(PLSMatrixAccess obj) {
        switch (this.m_MatrixType) {
            case PLS1_B_HAT: {
                return this.matrixToSpreadSheet(obj.getPLS1bHat(), this.m_MatrixType.toString());
            }
            case PLS1_P: {
                return this.matrixToSpreadSheet(obj.getPLS1P(), this.m_MatrixType.toString());
            }
            case PLS1_REGVECTOR: {
                return this.matrixToSpreadSheet(obj.getPLS1RegVector(), this.m_MatrixType.toString());
            }
            case PLS1_W: {
                return this.matrixToSpreadSheet(obj.getPLS1W(), this.m_MatrixType.toString());
            }
            case SIMPLS_B: {
                return this.matrixToSpreadSheet(obj.getSimplsB(), this.m_MatrixType.toString());
            }
            case SIMPLS_W: {
                return this.matrixToSpreadSheet(obj.getSimplsW(), this.m_MatrixType.toString());
            }
        }
        return null;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = null;
        if (this.m_InputToken.getPayload() instanceof PLSMatrixAccess) {
            sheet = this.getMatrix((PLSMatrixAccess)this.m_InputToken.getPayload());
        } else if (this.m_InputToken.getPayload() instanceof WekaModelContainer) {
            sheet = this.getMatrix((Classifier)((WekaModelContainer)((Object)this.m_InputToken.getPayload())).getValue("Model"));
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("sheet: " + sheet);
        }
        if (sheet != null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }

    public static enum MatrixType {
        PLS1_REGVECTOR,
        PLS1_P,
        PLS1_W,
        PLS1_B_HAT,
        SIMPLS_W,
        SIMPLS_B;

    }
}

