/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.Shortening;
import adams.core.io.ModelFileHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.instance.Instance;
import adams.flow.container.OptionalContainerOutput;
import adams.flow.container.WekaFilterContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractWekaInstanceAndWekaInstancesTransformer;
import java.util.Hashtable;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;

public class WekaFilter
extends AbstractWekaInstanceAndWekaInstancesTransformer
implements ProvenanceSupporter,
OptionalContainerOutput,
ModelFileHandler {
    private static final long serialVersionUID = 9078845385089445202L;
    public static final String BACKUP_INITIALIZED = "initialized";
    protected Filter m_Filter;
    protected Filter m_ActualFilter;
    protected boolean m_InitializeOnce;
    protected boolean m_KeepRelationName;
    protected boolean m_OutputContainer;
    protected PlaceholderFile m_ModelFile;
    protected boolean m_Initialized;

    public String globalInfo() {
        return "Filters Instances/Instance objects using the specified filter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new AllFilter());
        this.m_OptionManager.add("model", "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("init-once", "initializeOnce", (Object)false);
        this.m_OptionManager.add("keep", "keepRelationName", (Object)false);
        this.m_OptionManager.add("output-container", "outputContainer", (Object)false);
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
        this.reset();
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the Instances/Instance objects.";
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelFile = value;
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelFile;
    }

    public String modelFileTipText() {
        return "The file with the serialized filter to load and use instead (when not pointing to a directory).";
    }

    public void setInitializeOnce(boolean value) {
        this.m_InitializeOnce = value;
        this.reset();
    }

    public boolean getInitializeOnce() {
        return this.m_InitializeOnce;
    }

    public String initializeOnceTipText() {
        return "If set to true, then the filter will get initialized only with the first batch of data; otherwise every time data gets passed through.";
    }

    public void setKeepRelationName(boolean value) {
        this.m_KeepRelationName = value;
        this.reset();
    }

    public boolean getKeepRelationName() {
        return this.m_KeepRelationName;
    }

    public String keepRelationNameTipText() {
        return "If set to true, then the filter won't change the relation name of the incoming dataset.";
    }

    public void setOutputContainer(boolean value) {
        this.m_OutputContainer = value;
        this.reset();
    }

    public boolean getOutputContainer() {
        return this.m_OutputContainer;
    }

    public String outputContainerTipText() {
        return "If enabled, a " + WekaFilterContainer.class.getName() + " is output with the filter and the filtered data (Instance or Instances).";
    }

    @Override
    public Class[] generates() {
        if (this.m_OutputContainer) {
            return new Class[]{WekaFilterContainer.class};
        }
        return super.generates();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.m_Filter), (int)40));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelFile", (Object)this.m_ModelFile, (String)", model: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keepRelationName", (boolean)this.m_KeepRelationName, (String)"keep relation name", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputContainer", (boolean)this.m_OutputContainer, (String)"output container", (String)", ");
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INITIALIZED);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_INITIALIZED, this.m_Initialized);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INITIALIZED)) {
            this.m_Initialized = (Boolean)state.get(BACKUP_INITIALIZED);
            state.remove(BACKUP_INITIALIZED);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    protected Token createToken(Object data) {
        if (this.m_OutputContainer) {
            WekaFilterContainer cont;
            if (data instanceof Instances) {
                cont = new WekaFilterContainer(this.m_ActualFilter, (Instances)data);
            } else if (data instanceof weka.core.Instance) {
                cont = new WekaFilterContainer(this.m_ActualFilter, (weka.core.Instance)data);
            } else if (data instanceof Instance) {
                cont = new WekaFilterContainer(this.m_ActualFilter, (Instance)((Object)data));
            } else {
                throw new IllegalArgumentException("Unhandled data type: " + data.getClass().getName());
            }
            return new Token((Object)cont);
        }
        return new Token(data);
    }

    protected String doExecute() {
        String result = null;
        Instances data = null;
        weka.core.Instance inst = null;
        if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
            inst = (weka.core.Instance)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof Instance) {
            inst = ((Instance)((Object)this.m_InputToken.getPayload())).toInstance();
        } else if (this.m_InputToken.getPayload() instanceof Instances) {
            data = (Instances)this.m_InputToken.getPayload();
        } else {
            result = "Unhandled data type: " + this.m_InputToken.getPayload().getClass().getName();
        }
        if (result == null) {
            try {
                if (this.m_InitializeOnce && !this.m_Initialized || !this.m_InitializeOnce) {
                    if (data == null) {
                        data = new Instances(inst.dataset(), 0);
                        data.add(inst);
                    }
                    if (this.m_ModelFile.isDirectory()) {
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Creating copy of: " + OptionUtils.getCommandLine((Object)this.m_Filter));
                        }
                        this.m_ActualFilter = (Filter)OptionUtils.shallowCopy((Object)this.m_Filter);
                        Filter.makeCopy((Filter)this.m_Filter);
                        this.m_ActualFilter.setInputFormat(data);
                    } else if (this.m_ModelFile.exists()) {
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Loading serialized filter from: " + this.m_ModelFile);
                        }
                        this.m_ActualFilter = (Filter)SerializationHelper.read((String)this.m_ModelFile.getAbsolutePath());
                    } else {
                        throw new IllegalStateException("Filter file does not exist: " + this.m_ModelFile);
                    }
                }
                Instances filteredData = null;
                weka.core.Instance filteredInst = null;
                if (data != null) {
                    String relation = data.relationName();
                    filteredData = Filter.useFilter((Instances)data, (Filter)this.m_ActualFilter);
                    if (this.m_KeepRelationName) {
                        filteredData.setRelationName(relation);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Setting relation name: " + relation);
                        }
                    }
                    this.m_Initialized = true;
                } else {
                    String relation = inst.dataset().relationName();
                    this.m_ActualFilter.input(inst);
                    this.m_ActualFilter.batchFinished();
                    filteredInst = this.m_ActualFilter.output();
                    if (this.m_KeepRelationName) {
                        filteredInst.dataset().setRelationName(relation);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Setting relation name: " + relation);
                        }
                    }
                }
                if (inst != null) {
                    if (filteredInst != null) {
                        if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
                            this.m_OutputToken = new Token((Object)filteredInst);
                        } else {
                            Instance instA = new Instance();
                            instA.set(filteredInst);
                            this.m_OutputToken = this.createToken((Object)instA);
                        }
                    } else if (filteredData != null && filteredData.numInstances() > 0) {
                        this.m_OutputToken = this.createToken(filteredData.instance(0));
                    }
                } else {
                    this.m_OutputToken = this.createToken(filteredData);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to filter data: ", e);
            }
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

