/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.statistics.StatUtils;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractWekaPredictionsTransformer;
import java.util.ArrayList;
import weka.classifiers.CrossValidationHelper;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class WekaPredictionsToInstances
extends AbstractWekaPredictionsTransformer {
    private static final long serialVersionUID = -1552754008462778501L;

    public String globalInfo() {
        return "Generates weka.core.Instances from the predictions of an Evaluation object.";
    }

    protected String doExecute() {
        int[] indices;
        Evaluation eval;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof WekaEvaluationContainer) {
            eval = (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation");
            indices = (int[])((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Original indices");
        } else {
            eval = (Evaluation)this.m_InputToken.getPayload();
            indices = null;
        }
        Instances header = eval.getHeader();
        boolean nominal = header.classAttribute().isNominal();
        ArrayList<Prediction> predictions = eval.predictions();
        if (predictions != null) {
            int n;
            int i;
            ArrayList<String> values;
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            if (nominal && this.m_AddLabelIndex) {
                values = new ArrayList<String>();
                for (i = 0; i < header.classAttribute().numValues(); ++i) {
                    values.add(i + 1 + ":" + header.classAttribute().value(i));
                }
                atts.add(new Attribute("Actual", values));
            } else {
                atts.add(header.classAttribute().copy("Actual"));
            }
            if (nominal && this.m_AddLabelIndex) {
                values = new ArrayList();
                for (i = 0; i < header.classAttribute().numValues(); ++i) {
                    values.add(i + 1 + ":" + header.classAttribute().value(i));
                }
                atts.add(new Attribute("Predicted", values));
            } else {
                atts.add(header.classAttribute().copy("Predicted"));
            }
            int indexErr = -1;
            if (this.m_ShowError) {
                indexErr = atts.size();
                if (nominal) {
                    values = new ArrayList();
                    values.add("n");
                    values.add("y");
                    atts.add(new Attribute("Error", values));
                } else {
                    atts.add(new Attribute("Error"));
                }
            }
            int indexProb = -1;
            if (this.m_ShowProbability && nominal) {
                indexProb = atts.size();
                atts.add(new Attribute("Probability"));
            }
            int indexDist = -1;
            if (this.m_ShowDistribution && nominal) {
                indexDist = atts.size();
                for (n = 0; n < header.classAttribute().numValues(); ++n) {
                    atts.add(new Attribute("Distribution (" + header.classAttribute().value(n) + ")"));
                }
            }
            int indexWeight = -1;
            if (this.m_ShowWeight) {
                indexWeight = atts.size();
                atts.add(new Attribute("Weight"));
            }
            Instances data = new Instances("Predictions", atts, predictions.size());
            data.setClassIndex(1);
            if (indices != null) {
                predictions = CrossValidationHelper.alignPredictions(predictions, indices);
            }
            for (i = 0; i < predictions.size(); ++i) {
                Prediction pred = predictions.get(i);
                double[] vals = new double[data.numAttributes()];
                vals[0] = pred.actual();
                vals[1] = pred.predicted();
                if (this.m_ShowError) {
                    vals[indexErr] = nominal ? (pred.actual() != pred.predicted() ? 1.0 : 0.0) : (this.m_UseAbsoluteError ? Math.abs(pred.actual() - pred.predicted()) : pred.actual() - pred.predicted());
                }
                if (this.m_ShowProbability && nominal) {
                    vals[indexProb] = StatUtils.max((double[])((NominalPrediction)pred).distribution());
                }
                if (this.m_ShowDistribution && nominal) {
                    for (n = 0; n < header.classAttribute().numValues(); ++n) {
                        vals[indexDist + n] = ((NominalPrediction)pred).distribution()[n];
                    }
                }
                if (this.m_ShowWeight) {
                    vals[indexWeight] = pred.weight();
                }
                data.add((Instance)new DenseInstance(1.0, vals));
            }
            this.m_OutputToken = new Token((Object)data);
        } else {
            this.getLogger().severe("No predictions available from Evaluation object!");
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }
}

