/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.env.Environment;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.WekaPredictionsToSpreadSheet;
import java.util.ArrayList;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class WekaSpreadSheetToPredictions
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -2097531874480331676L;
    protected SpreadSheetColumnIndex m_Actual;
    protected SpreadSheetColumnIndex m_Predicted;

    public String globalInfo() {
        return "Turns the predictions stored in the incoming spreadsheet (actual and predicted) into a Weka " + Evaluation.class.getName() + " object.\nNB: Only works for numeric classes.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{WekaPredictionsToSpreadSheet.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual", "actual", (Object)new SpreadSheetColumnIndex("Actual"));
        this.m_OptionManager.add("predicted", "predicted", (Object)new SpreadSheetColumnIndex("Predicted"));
    }

    public void setActual(SpreadSheetColumnIndex value) {
        this.m_Actual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActual() {
        return this.m_Actual;
    }

    public String actualTipText() {
        return "The column with the actual values.";
    }

    public void setPredicted(SpreadSheetColumnIndex value) {
        this.m_Predicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredicted() {
        return this.m_Predicted;
    }

    public String predictedTipText() {
        return "The column with the predicted values.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"actual", (Object)this.m_Actual, (String)"actual: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"predicted", (Object)this.m_Predicted, (String)", predicted: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Evaluation.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Actual.setData((Object)sheet);
        this.m_Predicted.setData((Object)sheet);
        if (this.m_Actual.getIntIndex() == -1) {
            result = "'Actual' column not found: " + this.m_Actual;
        } else if (this.m_Predicted.getIntIndex() == -1) {
            result = "'Predicted' column not found: " + this.m_Predicted;
        }
        double[] actual = null;
        double[] predicted = null;
        if (result == null) {
            actual = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)this.m_Actual.getIntIndex());
            if (actual.length != (predicted = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)this.m_Predicted.getIntIndex())).length) {
                result = "Number of actual and predicted values differ: " + actual.length + " != " + predicted.length;
            } else if (actual.length == 0) {
                result = "No numeric values?";
            }
        }
        if (result == null) {
            int i;
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("Prediction"));
            Instances data = new Instances(sheet.hasName() ? sheet.getName() : Environment.getInstance().getProject(), atts, actual.length);
            data.setClassIndex(0);
            for (i = 0; i < actual.length; ++i) {
                DenseInstance inst = new DenseInstance(1.0, new double[]{actual[i]});
                data.add((Instance)inst);
            }
            try {
                Evaluation eval = new Evaluation(data);
                for (i = 0; i < actual.length; ++i) {
                    eval.evaluateModelOnceAndRecordPrediction(new double[]{predicted[i]}, data.instance(i));
                }
                this.m_OutputToken = new Token((Object)eval);
            }
            catch (Exception e) {
                result = this.handleException("Failed to create 'fake' Evaluation object!", e);
            }
        }
        return result;
    }
}

