/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;

public class WekaSubsets
extends AbstractTransformer {
    private static final long serialVersionUID = 4717726637561070097L;
    protected WekaAttributeIndex m_Index;
    protected List<Instances> m_Queue;

    public String globalInfo() {
        return "Splits the dataset based on the unique values of the specified attribute: all rows with the same unique value form a subset.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new WekaAttributeIndex("1"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Index = new WekaAttributeIndex();
        this.m_Queue = new ArrayList<Instances>();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)((Object)this.m_Index));
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the attribute to use for splitting the dataset into subsets; " + this.m_Index.getExample();
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        Instances data = new Instances((Instances)this.m_InputToken.getPayload());
        this.m_Index.setData(data);
        int index = this.m_Index.getIntIndex();
        data.sort(index);
        Double old = null;
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            Double curr = inst.value(index);
            if (old == null || !curr.equals(old)) {
                this.m_Queue.add(new Instances(data, data.numInstances()));
                old = curr;
            }
            this.m_Queue.get(this.m_Queue.size() - 1).add(inst);
        }
        for (Instances sub : this.m_Queue) {
            sub.compactify();
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return !this.m_Queue.isEmpty();
    }

    public Token output() {
        Token result = new Token((Object)this.m_Queue.get(0));
        this.m_Queue.remove(0);
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }
}

