/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaEvaluationContainer;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractCallableWekaClassifierEvaluator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.core.Instances;

public class WekaTrainTestSetEvaluator
extends AbstractCallableWekaClassifierEvaluator
implements ProvenanceSupporter {
    private static final long serialVersionUID = -1092101024095887007L;

    public String globalInfo() {
        return "Trains a classifier on an incoming training dataset (from a container) and then evaluates it on the test set (also from a container).\nThe classifier setup being used in the evaluation is a callable 'Classifier' actor.";
    }

    @Override
    public String classifierTipText() {
        return "The callable classifier actor to train and evaluate on the test data.";
    }

    public Class[] accepts() {
        return new Class[]{WekaTrainTestSetContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Classifier cls = this.getClassifierInstance();
            if (cls == null) {
                throw new IllegalStateException("Classifier '" + this.getClassifier() + "' not found!");
            }
            WekaTrainTestSetContainer cont = (WekaTrainTestSetContainer)((Object)this.m_InputToken.getPayload());
            Instances train = (Instances)cont.getValue("Train");
            Instances test = (Instances)cont.getValue("Test");
            cls.buildClassifier(train);
            this.initOutputBuffer();
            this.m_Output.setHeader(train);
            Evaluation eval = new Evaluation(train);
            eval.setDiscardPredictions(this.m_DiscardPredictions);
            eval.evaluateModel(cls, test, new Object[]{this.m_Output});
            this.m_OutputToken = this.m_Output instanceof Null ? new Token((Object)new WekaEvaluationContainer(eval, cls)) : (this.m_AlwaysUseContainer ? new Token((Object)new WekaEvaluationContainer(eval, cls, this.m_Output.getBuffer().toString())) : new Token((Object)this.m_Output.getBuffer().toString()));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to evaluate: ", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

