/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLister;
import adams.gui.goe.AbstractEditorRegistration;
import adams.gui.goe.ColorEditor;
import adams.gui.goe.Editors;
import adams.gui.goe.FileEditor;
import adams.gui.goe.GenericObjectEditor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;

public class WekaEditorsRegistration
extends AbstractEditorRegistration {
    private static final long serialVersionUID = -2908979337117222215L;
    public static final String PROPERTY_WEKAEDITORS = "adams.gui.wekaeditors";
    protected static boolean m_UseWekaEditors = Boolean.getBoolean("adams.gui.wekaeditors");
    protected static boolean m_Registered;

    protected boolean hasRegistered() {
        return m_Registered;
    }

    protected void registerEditors(Properties props) {
        for (Object key : props.keySet()) {
            try {
                if (key.toString().endsWith("[]")) continue;
                Class<?> cls = Class.forName("" + key);
                PropertyEditor editor = PropertyEditorManager.findEditor(cls);
                Class<GenericObjectEditor> newEditor = null;
                if (editor instanceof weka.gui.GenericObjectEditor) {
                    newEditor = GenericObjectEditor.class;
                } else if (editor instanceof weka.gui.FileEditor) {
                    newEditor = FileEditor.class;
                } else if (editor instanceof weka.gui.ColorEditor) {
                    newEditor = ColorEditor.class;
                }
                if (newEditor == null) continue;
                Editors.registerCustomEditor(cls, newEditor);
                this.getLogger().info("Registering " + cls.getName() + ": " + editor.getClass().getName() + " -> " + newEditor.getName());
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to register editors: " + key, (Throwable)e);
            }
        }
    }

    protected void registerHierarchies(Properties props) {
        for (Object key : props.keySet()) {
            String superclass = "" + key;
            String[] classes = props.getProperty(superclass).replaceAll(" ", "").split(",");
            HashSet<String> packages = new HashSet<String>();
            for (String clsname : classes) {
                if (clsname.trim().isEmpty()) continue;
                try {
                    Class<?> cls = Class.forName(clsname);
                    packages.add(cls.getPackage().getName());
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().warning("Class not found: " + clsname);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to register class hierarchy: " + key, (Throwable)e);
                }
            }
            if (packages.size() <= 0) continue;
            ClassLister.getSingleton().addHierarchy(superclass, packages.toArray(new String[packages.size()]));
            this.getLogger().info("Registering class hierarchy: " + key);
        }
    }

    public static boolean useWekaEditors() {
        return m_UseWekaEditors;
    }

    protected boolean doRegister() {
        weka.gui.GenericObjectEditor.determineClasses();
        weka.gui.GenericObjectEditor.registerEditors();
        if (!WekaEditorsRegistration.useWekaEditors()) {
            this.registerEditors(AccessibleGenericObjectEditor.getProperties());
        }
        this.registerHierarchies(AccessibleGenericObjectEditor.getProperties());
        m_Registered = true;
        return true;
    }

    public static class AccessibleGenericObjectEditor
    extends weka.gui.GenericObjectEditor {
        public static Properties getProperties() {
            return EDITOR_PROPERTIES;
        }
    }
}

