/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.classhelp;

import adams.core.ClassLocator;
import adams.gui.core.ConsolePanel;
import adams.gui.tools.classhelp.AbstractHelpGenerator;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.OptionHandler;
import weka.core.OptionMetadata;
import weka.gui.PropertySheetPanel;

public class WekaOptionHandlerHelpGenerator
extends AbstractHelpGenerator {
    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(OptionHandler.class, (Class)cls);
    }

    public boolean isHtml(Class cls) {
        return false;
    }

    public String generateHelp(Class cls) {
        MethodDescriptor[] methods;
        Object obj;
        StringBuilder result = null;
        try {
            obj = cls.newInstance();
        }
        catch (Exception ex) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Failed to instantiate class: " + cls.getName(), (Throwable)ex);
            return null;
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            methods = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Couldn't introspect class: " + cls.getName(), (Throwable)ex);
            return null;
        }
        Object[] args = new Object[]{};
        boolean firstTip = true;
        StringBuilder options = new StringBuilder();
        for (MethodDescriptor method : methods) {
            String name = method.getDisplayName();
            Method meth = method.getMethod();
            OptionMetadata meta = meth.getAnnotation(OptionMetadata.class);
            if ((name.endsWith("TipText") || meta != null) && (meth.getReturnType().equals(String.class) || meta != null)) {
                try {
                    String tempTip = meta != null ? meta.description() : (String)meth.invoke(obj, args);
                    String string = name = meta != null ? meta.displayName() : name;
                    if (firstTip) {
                        options.append("OPTIONS\n");
                        firstTip = false;
                    }
                    tempTip = tempTip.replace("<html>", "").replace("</html>", "").replace("<br>", "\n").replace("<p>", "\n\n");
                    options.append(name.replace("TipText", "")).append(" -- ");
                    options.append(tempTip).append("\n\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!name.equals("globalInfo") || !meth.getReturnType().equals(String.class)) continue;
            try {
                String globalInfo = (String)meth.invoke(obj, args);
                result = new StringBuilder("NAME\n");
                result.append(cls.getName()).append("\n\n");
                result.append("SYNOPSIS\n").append(globalInfo).append("\n\n");
                if (!(obj instanceof CapabilitiesHandler)) continue;
                result.append(PropertySheetPanel.addCapabilities((String)"CAPABILITIES", (Capabilities)((CapabilitiesHandler)obj).getCapabilities()));
                if (!(obj instanceof MultiInstanceCapabilitiesHandler)) continue;
                result.append(PropertySheetPanel.addCapabilities((String)"MI CAPABILITIES", (Capabilities)((MultiInstanceCapabilitiesHandler)obj).getMultiInstanceCapabilities()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result != null) {
            result.append(options.toString());
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }
}

