/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Shortening;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.weka.classattribute.AbstractClassAttributeHeuristic;
import adams.data.weka.classattribute.LastAttribute;
import adams.data.weka.relationname.AbstractRelationNameHeuristic;
import adams.data.weka.relationname.NoChange;
import adams.env.Environment;
import adams.gui.action.AbstractBaseAction;
import adams.gui.action.BaseAction;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.core.BaseMenu;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.FileContainer;
import adams.gui.tools.wekainvestigator.job.InvestigatorJob;
import adams.gui.tools.wekainvestigator.source.AbstractSource;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.InvestigatorTabbedPane;
import adams.gui.tools.wekainvestigator.tab.LogTab;
import adams.gui.workspace.AbstractWorkspacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;

public class InvestigatorPanel
extends AbstractWorkspacePanel
implements StatusMessageHandler,
CleanUpHandler {
    private static final long serialVersionUID = 7442747356297265526L;
    public static final String SESSION_FILE = "WekaInvestigatorSession.props";
    public static final String FILENAME = "WekaInvestigator.props";
    public static final String FILENAME_SHORTCUTS = "WekaInvestigatorShortcuts.props";
    protected static Properties m_Properties;
    protected static Properties m_ShortcutProperties;
    protected InvestigatorTabbedPane m_TabbedPane;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected BaseMenu m_MenuFileSources;
    protected BaseAction m_ActionFileClose;
    protected JCheckBoxMenuItem m_MenuItemOptionsUndoEnabled;
    protected JCheckBoxMenuItem m_MenuItemOptionsCalculateModelSize;
    protected JCheckBoxMenuItem m_MenuItemOptionsSortAttributeNames;
    protected BaseAction m_ActionFileOpen;
    protected BaseAction m_ActionFileClassAttribute;
    protected BaseAction m_ActionFileRelationName;
    protected BaseAction m_ActionFileStopJob;
    protected BaseMenu m_MenuTabNewTab;
    protected BaseAction m_ActionTabCopyTab;
    protected BaseAction m_ActionTabCloseTab;
    protected BaseAction m_ActionTabCloseAllTabs;
    protected StringBuilder m_Log;
    protected List<DataContainer> m_Data;
    protected WekaFileChooser m_FileChooser;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandler;
    protected AbstractClassAttributeHeuristic m_ClassAttributeHeuristic;
    protected AbstractRelationNameHeuristic m_RelationNameHeuristic;
    protected DateFormat m_StatusBarDateFormat;
    protected Thread m_Worker;
    protected InvestigatorJob m_Job;

    protected void initialize() {
        super.initialize();
        this.m_Log = new StringBuilder();
        this.m_Data = new ArrayList<DataContainer>();
        this.m_RecentFilesHandler = null;
        this.m_Worker = null;
        this.m_Job = null;
        this.m_StatusBarDateFormat = DateUtils.getTimeFormatter();
        this.m_FileChooser = new WekaFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        String cmdline = InvestigatorPanel.getProperties().getProperty("General.ClassAttributeHeuristic", OptionUtils.getCommandLine((Object)((Object)new LastAttribute())));
        try {
            this.m_ClassAttributeHeuristic = (AbstractClassAttributeHeuristic)((Object)OptionUtils.forAnyCommandLine(AbstractClassAttributeHeuristic.class, (String)cmdline));
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate class attribute heuristic: " + cmdline, (Throwable)e);
            this.m_ClassAttributeHeuristic = new LastAttribute();
        }
        cmdline = InvestigatorPanel.getProperties().getProperty("General.RelationNameHeuristic", OptionUtils.getCommandLine((Object)((Object)new NoChange())));
        try {
            this.m_RelationNameHeuristic = (AbstractRelationNameHeuristic)((Object)OptionUtils.forAnyCommandLine(AbstractRelationNameHeuristic.class, (String)cmdline));
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate class attribute heuristic: " + cmdline, (Throwable)e);
            this.m_RelationNameHeuristic = new NoChange();
        }
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new InvestigatorTabbedPane(this);
        this.add((Component)((Object)this.m_TabbedPane), "Center");
        this.m_StatusBar = new BaseStatusBar();
        this.m_StatusBar.setMouseListenerActive(true);
        this.add((Component)this.m_StatusBar, "South");
        this.initActions();
    }

    public void addDefaultTabs() {
        String[] classes;
        for (String cls : classes = InvestigatorPanel.getProperties().getProperty("General.DefaultTabs", LogTab.class.getName()).split(",")) {
            try {
                AbstractInvestigatorTab tab = (AbstractInvestigatorTab)Class.forName(cls).newInstance();
                this.m_TabbedPane.addTab(tab);
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate investigator tab: ", (Throwable)e);
            }
        }
    }

    protected void initActions() {
        this.m_ActionTabCopyTab = new AbstractBaseAction(){
            private static final long serialVersionUID = 1028160012672649573L;

            protected void doActionPerformed(ActionEvent e) {
                InvestigatorJob job = new InvestigatorJob(InvestigatorPanel.this, "Copying tab"){

                    @Override
                    protected void doRun() {
                        int index = InvestigatorPanel.this.m_TabbedPane.getSelectedIndex();
                        if (index == -1) {
                            return;
                        }
                        AbstractInvestigatorTab tab = (AbstractInvestigatorTab)((Object)InvestigatorPanel.this.m_TabbedPane.getComponentAt(index));
                        MessageCollection errors = new MessageCollection();
                        try {
                            AbstractInvestigatorTab tabNew = (AbstractInvestigatorTab)tab.getClass().newInstance();
                            InvestigatorPanel.this.m_TabbedPane.addTab(tabNew);
                            tabNew.deserialize(Utils.deepCopy((Object)tab.serialize()), errors);
                        }
                        catch (Exception ex) {
                            errors.add("Failed to copy tab!", (Throwable)ex);
                        }
                        if (!errors.isEmpty()) {
                            GUIHelper.showErrorMessage((Component)((Object)InvestigatorPanel.this), (String)("Errors occurred when copying tab:\n" + errors));
                        }
                    }
                };
                InvestigatorPanel.this.startExecution(job);
            }
        };
        this.m_ActionTabCopyTab.setName("Copy tab");
        this.m_ActionTabCopyTab.setIcon((Icon)GUIHelper.getIcon((String)"copy.gif"));
        this.m_ActionTabCloseTab = new AbstractBaseAction(){
            private static final long serialVersionUID = 1028160012672649573L;

            protected void doActionPerformed(ActionEvent e) {
                int index = InvestigatorPanel.this.m_TabbedPane.getSelectedIndex();
                if (index > -1) {
                    InvestigatorPanel.this.m_TabbedPane.removeTabAt(index);
                }
                InvestigatorPanel.this.updateMenu();
            }
        };
        this.m_ActionTabCloseTab.setName("Close tab");
        this.m_ActionTabCloseTab.setIcon((Icon)GUIHelper.getIcon((String)"close_tab_focused.gif"));
        this.m_ActionTabCloseAllTabs = new AbstractBaseAction(){
            private static final long serialVersionUID = 2162739410818834253L;

            protected void doActionPerformed(ActionEvent e) {
                InvestigatorPanel.this.m_TabbedPane.removeAll();
                InvestigatorPanel.this.updateMenu();
            }
        };
        this.m_ActionTabCloseAllTabs.setName("Close all tabs");
        this.m_ActionTabCloseAllTabs.setIcon((Icon)GUIHelper.getEmptyIcon());
        this.m_ActionFileClose = new AbstractBaseAction(){
            private static final long serialVersionUID = -1104246458353845500L;

            protected void doActionPerformed(ActionEvent e) {
                InvestigatorPanel.this.closeParent();
            }
        };
        this.m_ActionFileClose.setName("Close");
        this.m_ActionFileClose.setIcon("exit.png");
        this.m_ActionFileClose.setAccelerator("ctrl pressed Q");
        this.m_ActionFileOpen = new AbstractBaseAction(){
            private static final long serialVersionUID = -1104246458353845500L;

            protected void doActionPerformed(ActionEvent e) {
                InvestigatorPanel.this.openFile();
            }
        };
        this.m_ActionFileOpen.setName("Open...");
        this.m_ActionFileOpen.setIcon("open.gif");
        this.m_ActionFileOpen.setAccelerator("ctrl pressed O");
        this.m_ActionFileClassAttribute = new AbstractBaseAction(){
            private static final long serialVersionUID = -1104246458353845500L;

            protected void doActionPerformed(ActionEvent e) {
                InvestigatorPanel.this.chooseClassAttributeHeuristic();
            }
        };
        this.m_ActionFileClassAttribute.setName("Class attribute...");
        this.m_ActionFileClassAttribute.setIcon((Icon)GUIHelper.getEmptyIcon());
        this.m_ActionFileRelationName = new AbstractBaseAction(){
            private static final long serialVersionUID = -1104246458353845500L;

            protected void doActionPerformed(ActionEvent e) {
                InvestigatorPanel.this.chooseRelationNameHeuristic();
            }
        };
        this.m_ActionFileRelationName.setName("Relation name...");
        this.m_ActionFileRelationName.setIcon((Icon)GUIHelper.getEmptyIcon());
        this.m_ActionFileStopJob = new AbstractBaseAction(){
            private static final long serialVersionUID = 429814291989678829L;

            protected void doActionPerformed(ActionEvent e) {
                InvestigatorPanel.this.stopExecution();
            }
        };
        this.m_ActionFileStopJob.setName("Stop job");
        this.m_ActionFileStopJob.setIcon((Icon)GUIHelper.getIcon((String)"stop_red.gif"));
        this.m_ActionFileStopJob.setAccelerator("ctrl pressed K");
    }

    protected void updateActions() {
        this.m_ActionFileStopJob.setEnabled(this.isBusy());
        this.m_ActionTabCopyTab.setEnabled(this.m_TabbedPane.getSelectedIndex() > -1);
        this.m_ActionTabCloseTab.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_ActionTabCloseAllTabs.setEnabled(this.m_TabbedPane.getTabCount() > 0);
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            JMenuItem menuitem;
            Class[] classes;
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.updateMenu());
            result.add(menu);
            menu.add((Action)this.m_ActionFileOpen);
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandlerWithCommandline(SESSION_FILE, 10, (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    InvestigatorPanel.this.openRecent(e);
                }
            });
            this.m_MenuFileSources = new BaseMenu("Other sources");
            this.m_MenuFileSources.setIcon((Icon)GUIHelper.getEmptyIcon());
            menu.add((JMenuItem)this.m_MenuFileSources);
            for (Class cls : classes = ClassLister.getSingleton().getClasses(AbstractSource.class)) {
                try {
                    AbstractSource source = (AbstractSource)((Object)cls.newInstance());
                    source.setOwner(this);
                    menuitem = new JMenuItem((Action)((Object)source));
                    this.m_MenuFileSources.add(menuitem);
                }
                catch (Exception e2) {
                    ConsolePanel.getSingleton().append("Failed to instantiate source class: " + cls.getName(), (Throwable)e2);
                }
            }
            this.m_MenuFileSources.sort();
            menu.add((Action)this.m_ActionFileClassAttribute);
            menu.add((Action)this.m_ActionFileRelationName);
            menu.addSeparator();
            menu.add((Action)this.m_ActionFileStopJob);
            menu.addSeparator();
            menu.add((Action)this.m_ActionFileClose);
            menu = new JMenu("Options");
            menu.setMnemonic('O');
            menu.addChangeListener(e -> this.updateMenu());
            result.add(menu);
            this.m_MenuItemOptionsUndoEnabled = new JCheckBoxMenuItem("Undo enabled");
            this.m_MenuItemOptionsUndoEnabled.setIcon(GUIHelper.getIcon((String)"undo.gif"));
            this.m_MenuItemOptionsUndoEnabled.setSelected(InvestigatorPanel.getProperties().getBoolean("General.UndoEnabled", Boolean.valueOf(true)));
            this.m_MenuItemOptionsUndoEnabled.addActionListener(e -> this.toggleUndo());
            menu.add(this.m_MenuItemOptionsUndoEnabled);
            this.m_MenuItemOptionsCalculateModelSize = new JCheckBoxMenuItem("Calculate model size");
            this.m_MenuItemOptionsCalculateModelSize.setIcon(GUIHelper.getIcon((String)"object.gif"));
            this.m_MenuItemOptionsCalculateModelSize.setSelected(InvestigatorPanel.getProperties().getBoolean("General.CalculateModelSize", Boolean.valueOf(false)));
            menu.add(this.m_MenuItemOptionsCalculateModelSize);
            this.m_MenuItemOptionsSortAttributeNames = new JCheckBoxMenuItem("Sort attribute names");
            this.m_MenuItemOptionsSortAttributeNames.setIcon(GUIHelper.getIcon((String)"sort-ascending.png"));
            this.m_MenuItemOptionsSortAttributeNames.setSelected(InvestigatorPanel.getProperties().getBoolean("General.SortAttributeNames", Boolean.valueOf(true)));
            this.m_MenuItemOptionsSortAttributeNames.addActionListener(e -> this.toggleSortAttributeNames());
            menu.add(this.m_MenuItemOptionsSortAttributeNames);
            menu = new JMenu("Tab");
            menu.setMnemonic('T');
            menu.addChangeListener(e -> this.updateMenu());
            result.add(menu);
            this.m_MenuTabNewTab = new BaseMenu("New tab");
            this.m_MenuTabNewTab.setIcon((Icon)GUIHelper.getIcon((String)"new.gif"));
            menu.add((JMenuItem)this.m_MenuTabNewTab);
            for (Class cls : classes = ClassLister.getSingleton().getClasses(AbstractInvestigatorTab.class)) {
                try {
                    AbstractInvestigatorTab tab = (AbstractInvestigatorTab)cls.newInstance();
                    menuitem = new JMenuItem(tab.getTitle());
                    if (tab.getTabIcon() == null) {
                        menuitem.setIcon(GUIHelper.getEmptyIcon());
                    } else {
                        menuitem.setIcon(GUIHelper.getIcon((String)tab.getTabIcon()));
                    }
                    if (InvestigatorPanel.getShortcutProperties().hasKey("Tab-" + cls.getName())) {
                        menuitem.setAccelerator(GUIHelper.getKeyStroke((String)InvestigatorPanel.getShortcutProperties().getProperty("Tab-" + cls.getName())));
                    }
                    menuitem.addActionListener(e -> {
                        try {
                            AbstractInvestigatorTab tabNew = (AbstractInvestigatorTab)cls.newInstance();
                            this.m_TabbedPane.addTab(tabNew, true);
                        }
                        catch (Exception ex) {
                            ConsolePanel.getSingleton().append("Failed to instantiate tab class: " + cls.getName(), (Throwable)ex);
                        }
                    });
                    this.m_MenuTabNewTab.add(menuitem);
                }
                catch (Exception e3) {
                    ConsolePanel.getSingleton().append("Failed to instantiate tab class: " + cls.getName(), (Throwable)e3);
                }
            }
            this.m_MenuTabNewTab.sort();
            menu.add((Action)this.m_ActionTabCopyTab);
            menu.addSeparator();
            menu.add((Action)this.m_ActionTabCloseTab);
            menu.add((Action)this.m_ActionTabCloseAllTabs);
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateTitle() {
        this.setParentTitle(this.m_TitleGenerator.generate((String)null));
    }

    protected void updateMenu() {
        this.updateActions();
    }

    protected String getDefaultTitle() {
        return "WEKA Investigator";
    }

    public boolean isBusy() {
        return this.m_Worker != null;
    }

    public boolean startExecution(InvestigatorJob job) {
        if (this.isBusy()) {
            this.logAndShowMessage("Busy, cannot start: " + job.getTitle());
            return false;
        }
        this.m_Job = job;
        this.m_Worker = new Thread(job);
        this.m_Worker.start();
        this.m_ActionFileStopJob.setName("Stop: " + Shortening.shortenEnd((String)job.getTitle(), (int)40));
        this.updateMenu();
        return true;
    }

    public void stopExecution() {
        if (this.m_Worker == null) {
            return;
        }
        this.m_Worker.stop();
        this.logAndShowMessage("Stopped: " + this.m_Job.getTitle());
        this.executionFinished();
        this.updateMenu();
    }

    public void executionFinished() {
        this.m_Worker = null;
        this.m_Job = null;
        this.m_ActionFileStopJob.setName("Stop job");
        this.updateMenu();
    }

    protected String getTimestampPrefix() {
        return "[" + this.m_StatusBarDateFormat.format(new Date()) + "] ";
    }

    public synchronized void logMessage(String msg) {
        String prefix = this.getTimestampPrefix();
        this.m_Log.append(prefix + msg);
        this.m_Log.append("\n");
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            if (!(this.m_TabbedPane.getComponentAt(i) instanceof LogTab)) continue;
            ((LogTab)((Object)this.m_TabbedPane.getComponentAt(i))).append(prefix + msg);
        }
    }

    public void logAndShowMessage(String msg) {
        this.logMessage(msg);
        this.showStatus(msg);
    }

    public void logError(String msg, String title) {
        this.logAndShowMessage(msg);
        GUIHelper.showErrorMessage((Component)((Object)this), (String)msg, (String)title);
    }

    public StringBuilder getLog() {
        return this.m_Log;
    }

    public void clearLog() {
        this.m_Log.setLength(0);
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            if (!(this.m_TabbedPane.getComponentAt(i) instanceof LogTab)) continue;
            ((LogTab)((Object)this.m_TabbedPane.getComponentAt(i))).clearLog();
        }
    }

    public List<DataContainer> getData() {
        return this.m_Data;
    }

    public void fireDataChange(WekaInvestigatorDataEvent e) {
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            ((AbstractInvestigatorTab)((Object)this.m_TabbedPane.getComponentAt(i))).dataChanged(e);
        }
        this.updateMenu();
    }

    public InvestigatorTabbedPane getTabbedPane() {
        return this.m_TabbedPane;
    }

    public Instances updateClassAttribute(Instances data) {
        if (data.classIndex() == -1) {
            data.setClassIndex(this.m_ClassAttributeHeuristic.determineClassAttribute(data));
        }
        return data;
    }

    public Instances updateRelationName(File file, Instances data) {
        String newRelation = this.m_RelationNameHeuristic.determineRelationName(file, data);
        if (newRelation != null) {
            data.setRelationName(newRelation);
        }
        return data;
    }

    public String addRecentFile(File file, AbstractFileLoader loader) {
        if (this.m_RecentFilesHandler == null) {
            return null;
        }
        if (loader == null) {
            loader = this.m_FileChooser.getReaderForFile(file);
        }
        if (loader == null) {
            return "Failed to determine loader for: " + file;
        }
        this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(file, (Object)loader));
        return null;
    }

    public void openFile() {
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        final AbstractFileLoader loader = (AbstractFileLoader)this.m_FileChooser.getReader();
        final File[] files = this.m_FileChooser.getSelectedFiles();
        InvestigatorJob job = new InvestigatorJob(this, "Loading: " + Utils.arrayToString((Object)files)){

            @Override
            protected void doRun() {
                for (File file : files) {
                    InvestigatorPanel.this.logAndShowMessage("Loading: " + file);
                    FileContainer cont = new FileContainer(loader, file);
                    cont.getUndo().setEnabled(InvestigatorPanel.this.isUndoEnabled());
                    InvestigatorPanel.this.updateClassAttribute(cont.getData());
                    InvestigatorPanel.this.updateRelationName(file, cont.getData());
                    SwingUtilities.invokeLater(() -> {
                        InvestigatorPanel.this.m_Data.add(cont);
                        InvestigatorPanel.this.addRecentFile(file, loader);
                        InvestigatorPanel.this.logAndShowMessage("Loaded: " + file);
                        InvestigatorPanel.this.fireDataChange(new WekaInvestigatorDataEvent(InvestigatorPanel.this, 2, InvestigatorPanel.this.m_Data.size() - 1));
                    });
                }
            }
        };
        this.startExecution(job);
    }

    public void openFile(final File file) {
        final AbstractFileLoader loader = this.m_FileChooser.getReaderForFile(file);
        if (loader == null) {
            this.logError("Failed to determine loader for: " + file, "Error loading");
            return;
        }
        InvestigatorJob job = new InvestigatorJob(this, "Loading: " + file){

            @Override
            protected void doRun() {
                FileContainer cont = new FileContainer(loader, file);
                cont.getUndo().setEnabled(InvestigatorPanel.this.isUndoEnabled());
                InvestigatorPanel.this.updateClassAttribute(cont.getData());
                InvestigatorPanel.this.updateRelationName(file, cont.getData());
                SwingUtilities.invokeLater(() -> {
                    InvestigatorPanel.this.m_Data.add(cont);
                    InvestigatorPanel.this.addRecentFile(file, loader);
                    InvestigatorPanel.this.logAndShowMessage("Loaded: " + file);
                    InvestigatorPanel.this.fireDataChange(new WekaInvestigatorDataEvent(InvestigatorPanel.this, 2, InvestigatorPanel.this.m_Data.size() - 1));
                });
            }
        };
        this.startExecution(job);
    }

    public void openRecent(final RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
        final AbstractFileLoader loader = (AbstractFileLoader)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler();
        if (loader == null) {
            this.logError("Failed to determine file loader for the following file:\n" + e.getItem(), "Error reloading data");
            return;
        }
        InvestigatorJob job = new InvestigatorJob(this, "Loading: " + e.getItem()){

            @Override
            protected void doRun() {
                try {
                    loader.setFile(((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile());
                    FileContainer cont = new FileContainer(loader, ((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile());
                    InvestigatorPanel.this.updateClassAttribute(cont.getData());
                    InvestigatorPanel.this.updateRelationName(((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile(), cont.getData());
                    SwingUtilities.invokeLater(() -> {
                        InvestigatorPanel.this.m_Data.add(cont);
                        InvestigatorPanel.this.m_FileChooser.setCurrentDirectory(((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile().getParentFile());
                        InvestigatorPanel.this.logAndShowMessage("Loaded: " + e.getItem());
                        InvestigatorPanel.this.fireDataChange(new WekaInvestigatorDataEvent(InvestigatorPanel.this, 2, InvestigatorPanel.this.m_Data.size() - 1));
                    });
                }
                catch (Exception ex) {
                    InvestigatorPanel.this.logError("Failed to load file:\n" + e.getItem() + "\n" + Utils.throwableToString((Throwable)ex), "Error reloading data");
                }
            }
        };
        this.startExecution(job);
    }

    public void chooseClassAttributeHeuristic() {
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setTitle("Select class attribute heuristic");
        dialog.getGOEEditor().setClassType(AbstractClassAttributeHeuristic.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.setCurrent((Object)this.m_ClassAttributeHeuristic);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            this.m_ClassAttributeHeuristic = (AbstractClassAttributeHeuristic)((Object)dialog.getCurrent());
        }
        dialog.dispose();
    }

    public void setClassAttributeHeuristic(AbstractClassAttributeHeuristic value) {
        this.m_ClassAttributeHeuristic = value;
    }

    public AbstractClassAttributeHeuristic getClassAttributeHeuristic() {
        return this.m_ClassAttributeHeuristic;
    }

    public void chooseRelationNameHeuristic() {
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setTitle("Select relation name heuristic");
        dialog.getGOEEditor().setClassType(AbstractRelationNameHeuristic.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.setCurrent((Object)this.m_RelationNameHeuristic);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            this.m_RelationNameHeuristic = (AbstractRelationNameHeuristic)((Object)dialog.getCurrent());
        }
        dialog.dispose();
    }

    public void setRelationNameHeuristic(AbstractRelationNameHeuristic value) {
        this.m_RelationNameHeuristic = value;
    }

    public AbstractRelationNameHeuristic getRelationNameHeuristic() {
        return this.m_RelationNameHeuristic;
    }

    public boolean isUndoEnabled() {
        this.getMenuBar();
        return this.m_MenuItemOptionsUndoEnabled.isSelected();
    }

    public void setUndoEnabled(boolean value) {
        this.getMenuBar();
        this.m_MenuItemOptionsUndoEnabled.setSelected(value);
    }

    protected void toggleUndo() {
        for (DataContainer cont : this.getData()) {
            cont.getUndo().setEnabled(this.isUndoEnabled());
        }
        WekaInvestigatorDataEvent event = new WekaInvestigatorDataEvent(this, this.isUndoEnabled() ? 101 : 102);
        this.fireDataChange(event);
    }

    public boolean calculateModelSize() {
        if (this.m_MenuItemOptionsCalculateModelSize != null) {
            return this.m_MenuItemOptionsCalculateModelSize.isSelected();
        }
        return InvestigatorPanel.getProperties().getBoolean("General.CalculateModelSize", Boolean.valueOf(false));
    }

    public void setSortAttributeNames(boolean value) {
        this.getMenuBar();
        this.m_MenuItemOptionsSortAttributeNames.setSelected(value);
    }

    public boolean getSortAttributeNames() {
        this.getMenuBar();
        return this.m_MenuItemOptionsSortAttributeNames.isSelected();
    }

    protected void toggleSortAttributeNames() {
        WekaInvestigatorDataEvent event = new WekaInvestigatorDataEvent(this, this.getSortAttributeNames() ? 103 : 104);
        this.fireDataChange(event);
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(this.getTimestampPrefix() + msg);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Data.clear();
        this.m_TabbedPane.cleanUp();
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("weka investigator");
        }
        return m_Properties;
    }

    public static synchronized Properties getShortcutProperties() {
        if (m_ShortcutProperties == null) {
            m_ShortcutProperties = Environment.getInstance().read("weka investigator shortcuts");
        }
        return m_ShortcutProperties;
    }
}

