/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator;

import adams.core.MessageCollection;
import adams.data.weka.classattribute.AbstractClassAttributeHeuristic;
import adams.data.weka.relationname.AbstractRelationNameHeuristic;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.workspace.AbstractSerializableWorkspaceManagerPanel;
import adams.gui.workspace.AbstractWorkspaceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvestigatorWorkspaceHelper
extends AbstractWorkspaceHelper<InvestigatorPanel, AbstractSerializableWorkspaceManagerPanel<InvestigatorPanel>> {
    public static final String KEY_DATA = "data";
    public static final String KEY_TABS = "tabs";
    public static final String KEY_CLASSATTRIBUTE = "class attribute";
    public static final String KEY_RELATIONNAME = "relation name";
    public static final String KEY_UNDOENABLED = "undo enabled";

    public Object serialize(InvestigatorPanel panel) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(panel.getData());
        result.put(KEY_DATA, list);
        result.put(KEY_CLASSATTRIBUTE, (Object)panel.getClassAttributeHeuristic());
        result.put(KEY_RELATIONNAME, (Object)panel.getRelationNameHeuristic());
        result.put(KEY_UNDOENABLED, panel.isUndoEnabled());
        list = new ArrayList();
        for (int i = 0; i < panel.getTabbedPane().getTabCount(); ++i) {
            AbstractInvestigatorTab tab = (AbstractInvestigatorTab)((Object)panel.getTabbedPane().getComponentAt(i));
            list.add(tab.getClass().getName());
            list.add(tab.serialize());
        }
        result.put(KEY_TABS, list);
        return result;
    }

    public void deserialize(InvestigatorPanel panel, Object data, MessageCollection errors) {
        Map items = (Map)data;
        List list = (List)items.get(KEY_DATA);
        for (Object obj : list) {
            panel.getData().add((DataContainer)obj);
        }
        if (items.containsKey(KEY_CLASSATTRIBUTE)) {
            panel.setClassAttributeHeuristic((AbstractClassAttributeHeuristic)((Object)items.get(KEY_CLASSATTRIBUTE)));
        }
        if (items.containsKey(KEY_RELATIONNAME)) {
            panel.setRelationNameHeuristic((AbstractRelationNameHeuristic)((Object)items.get(KEY_RELATIONNAME)));
        }
        if (items.containsKey(KEY_UNDOENABLED)) {
            panel.setUndoEnabled((Boolean)items.get(KEY_UNDOENABLED));
        }
        list = (List)items.get(KEY_TABS);
        for (int i = 0; i < list.size(); i += 2) {
            try {
                Class<?> cls = Class.forName((String)list.get(i));
                AbstractInvestigatorTab tab = (AbstractInvestigatorTab)cls.newInstance();
                panel.getTabbedPane().addTab(tab, false);
                tab.deserialize(list.get(i + 1), errors);
                continue;
            }
            catch (Exception e) {
                errors.add("Failed to deserialize data (" + i + "-" + (i + 2) + ")!", (Throwable)e);
            }
        }
    }
}

