/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.core.io.PlaceholderFile;
import adams.gui.tools.wekainvestigator.data.AbstractDataContainer;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;

public class FileContainer
extends AbstractDataContainer {
    private static final long serialVersionUID = 6267905940957451551L;
    protected File m_Source;
    protected AbstractFileLoader m_Loader;

    public FileContainer(AbstractFileLoader loader, PlaceholderFile source) {
        this(loader, (File)source);
    }

    public FileContainer(AbstractFileLoader loader, File source) {
        try {
            loader.setFile(source.getAbsoluteFile());
            this.m_Data = ConverterUtils.DataSource.read((Loader)loader);
            this.m_Source = source;
            this.m_Loader = loader;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load dataset: " + source, e);
        }
    }

    public FileContainer(AbstractFileLoader loader, File source, Instances data) {
        try {
            loader.setFile(source.getAbsoluteFile());
            this.m_Data = data;
            this.m_Source = source;
            this.m_Loader = loader;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load dataset: " + source, e);
        }
    }

    @Override
    public String getSource() {
        if (this.m_Source == null) {
            return "<unknown>";
        }
        return this.m_Source.toString();
    }

    @Override
    public boolean canReload() {
        return this.m_Loader != null && this.m_Source != null && this.m_Source.exists();
    }

    @Override
    protected boolean doReload() {
        try {
            this.m_Loader.setFile(this.m_Source.getAbsoluteFile());
            this.m_Data = this.m_Loader.getDataSet();
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to reload: " + this.m_Source, (Throwable)e);
            return false;
        }
    }

    @Override
    protected Serializable[] getUndoData() {
        return new Serializable[]{this.m_Data, Boolean.valueOf(this.m_Modified), this.m_Loader, this.m_Source};
    }

    @Override
    protected void applyUndoData(Serializable[] data) {
        this.m_Data = (Instances)data[0];
        this.m_Modified = (Boolean)data[1];
        this.m_Loader = (AbstractFileLoader)data[2];
        this.m_Source = (File)data[3];
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Loader = null;
        this.m_Source = null;
    }
}

