/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.data;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.wekainvestigator.data.AbstractDataContainer;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import weka.core.Instances;

public class SpreadSheetContainer
extends AbstractDataContainer {
    private static final long serialVersionUID = 6267905940957451551L;
    protected File m_Source;
    protected SpreadSheetReader m_Reader;

    public SpreadSheetContainer(SpreadSheetReader reader, File source) {
        this(reader, new PlaceholderFile(source));
    }

    public SpreadSheetContainer(SpreadSheetReader reader, PlaceholderFile source) {
        try {
            SpreadSheet sheet = reader.read((File)source);
            SpreadSheetToWekaInstances conv = new SpreadSheetToWekaInstances();
            conv.setInput(sheet);
            String msg = conv.convert();
            if (msg != null) {
                throw new IllegalArgumentException("Failed to convert spreadsheet!\n" + msg);
            }
            this.m_Data = (Instances)conv.getOutput();
            this.m_Source = source;
            this.m_Reader = reader;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load dataset: " + source, e);
        }
    }

    @Override
    public String getSource() {
        if (this.m_Source == null) {
            return "<unknown>";
        }
        return this.m_Source.toString();
    }

    @Override
    public boolean canReload() {
        return this.m_Reader != null && this.m_Source != null && this.m_Source.exists();
    }

    @Override
    protected boolean doReload() {
        try {
            SpreadSheet sheet = this.m_Reader.read(this.m_Source);
            SpreadSheetToWekaInstances conv = new SpreadSheetToWekaInstances();
            conv.setInput(sheet);
            String msg = conv.convert();
            if (msg != null) {
                throw new IllegalArgumentException("Failed to convert spreadsheet!\n" + msg);
            }
            this.m_Data = (Instances)conv.getOutput();
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to reload: " + this.m_Source, (Throwable)e);
            return false;
        }
    }

    @Override
    protected Serializable[] getUndoData() {
        return new Serializable[]{this.m_Data, Boolean.valueOf(this.m_Modified), this.m_Reader, this.m_Source};
    }

    @Override
    protected void applyUndoData(Serializable[] data) {
        this.m_Data = (Instances)data[0];
        this.m_Modified = (Boolean)data[1];
        this.m_Reader = (SpreadSheetReader)data[2];
        this.m_Source = (File)data[3];
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Reader = null;
        this.m_Source = null;
    }
}

