/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.flow.container.WekaTrainTestSetContainer;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import weka.classifiers.RandomSplitGenerator;
import weka.core.Instances;

public class Split
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Split() {
        this.setName("Split");
        this.setIcon("percentage.gif");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        ParameterPanel params = new ParameterPanel();
        JCheckBox checkboxPreserveOrder = new JCheckBox();
        checkboxPreserveOrder.setToolTipText("Whether to preserve the order or randomize the data");
        params.addParameter("Preserve order", (Component)checkboxPreserveOrder);
        NumberTextField textSeed = new NumberTextField(NumberTextField.Type.INTEGER);
        textSeed.setValue((Number)1);
        textSeed.setToolTipText("The seed value to use when randomizing the data");
        params.addParameter("Seed", (Component)textSeed);
        NumberTextField textPercentage = new NumberTextField(NumberTextField.Type.DOUBLE);
        textPercentage.setValue((Number)66.0);
        textPercentage.setToolTipText("The percentage to use for the training set (0;100)");
        params.addParameter("Train percentage", (Component)textPercentage);
        ApprovalDialog dialog = GUIHelper.getParentDialog((Container)((Object)this.getOwner())) != null ? new ApprovalDialog(GUIHelper.getParentDialog((Container)((Object)this.getOwner())), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(GUIHelper.getParentFrame((Container)((Object)this.getOwner())), true);
        dialog.setTitle("Split");
        dialog.getContentPane().add((Component)params, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this.getOwner().getOwner()));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        int seed = textSeed.getValue().intValue();
        double percentage = textPercentage.getValue().doubleValue();
        if (percentage <= 0.0 || percentage >= 100.0) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)("Percentage must satisfy 0 < x < 100, provided: " + percentage));
            return;
        }
        DataContainer cont = this.getSelectedData()[0];
        this.logMessage("Splitting dataset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
        RandomSplitGenerator generator = checkboxPreserveOrder.isSelected() ? new RandomSplitGenerator(cont.getData(), percentage / 100.0) : new RandomSplitGenerator(cont.getData(), seed, percentage / 100.0);
        WekaTrainTestSetContainer ttcont = generator.next();
        MemoryContainer trainCont = new MemoryContainer((Instances)ttcont.getValue("Train"));
        trainCont.getData().setRelationName(cont.getData().relationName() + "-train");
        MemoryContainer testCont = new MemoryContainer((Instances)ttcont.getValue("Test"));
        testCont.getData().setRelationName(cont.getData().relationName() + "-test");
        this.getData().add(trainCont);
        this.getData().add(testCont);
        this.logMessage("Successfully split " + cont.getID() + " into " + trainCont.getID() + " and " + testCont.getID() + "!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, new int[]{this.getData().size() - 2, this.getData().size() - 1}));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

