/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.evaluation;

import adams.core.ByteFormat;
import adams.core.GlobalInfoSupporter;
import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.SizeOf;
import adams.core.StatusMessageHandler;
import adams.core.logging.LoggingObject;
import adams.data.spreadsheet.MetaData;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.output.AbstractResultItem;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import java.awt.BorderLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public abstract class AbstractEvaluation<T extends AbstractInvestigatorTab, R extends AbstractResultItem>
extends LoggingObject
implements StatusMessageHandler,
GlobalInfoSupporter {
    private static final long serialVersionUID = -5847790432092994409L;
    protected T m_Owner;
    protected JPanel m_PanelOptions;

    protected AbstractEvaluation() {
        this.initialize();
        this.initGUI();
    }

    protected void initialize() {
    }

    protected void initGUI() {
        this.m_PanelOptions = new JPanel(new BorderLayout());
    }

    public void setOwner(T value) {
        this.m_Owner = value;
        this.update();
    }

    public T getOwner() {
        return this.m_Owner;
    }

    public abstract String getName();

    public JPanel getPanel() {
        return this.m_PanelOptions;
    }

    protected int getTestingUpdateInterval() {
        return AbstractEvaluation.getProperties().getInteger("General.TestingUpdateInterval", Integer.valueOf(1000));
    }

    public R addToHistory(AbstractNamedHistoryPanel<R> history, R item) {
        history.addEntry(((AbstractResultItem)((Object)item)).getName(), item);
        history.setSelectedIndex(history.count() - 1);
        return item;
    }

    public String toString() {
        return this.getName();
    }

    public abstract void update();

    public abstract void activate(int var1);

    public void showStatus(String msg) {
        ((AbstractInvestigatorTab)this.m_Owner).logMessage(msg);
    }

    protected boolean isValidDataIndex(JComboBox combobox) {
        if (combobox.getSelectedIndex() == -1) {
            return false;
        }
        return combobox.getSelectedIndex() < ((AbstractInvestigatorTab)this.getOwner()).getData().size();
    }

    public void addObjectSize(MetaData meta, String key, Object obj) {
        if (!((AbstractInvestigatorTab)this.getOwner()).getOwner().calculateModelSize()) {
            return;
        }
        int size = SizeOf.sizeOf((Object)obj);
        meta.add(key, (Object)(ByteFormat.toBestFitBytes((double)size, (int)1) + " (" + size + " bytes)"));
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    public void deserialize(Map<String, Object> data, MessageCollection errors) {
    }

    public static Properties getProperties() {
        return InvestigatorPanel.getProperties();
    }
}

