/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.output;

import adams.core.CleanUpHandler;
import adams.core.Utils;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.gui.core.SimpleLogPanel;
import adams.gui.tools.wekainvestigator.output.OutputTabbedPane;
import java.util.Date;
import weka.core.Instances;

public abstract class AbstractResultItem
extends LoggingObject
implements CleanUpHandler {
    private static final long serialVersionUID = -3409493446200539772L;
    public static final int MAX_RELATIONNAME_LENGTH = 30;
    protected Date m_Timestamp;
    protected String m_Name;
    protected Instances m_Header;
    protected StringBuilder m_Log;
    protected SimpleLogPanel m_LogPanel;
    protected transient OutputTabbedPane m_TabbedPane;

    protected AbstractResultItem(Instances header) {
        this.m_Header = header;
        this.m_Timestamp = new Date();
        this.m_Name = null;
        this.m_Log = new StringBuilder();
        this.m_LogPanel = new SimpleLogPanel();
    }

    protected abstract String createName();

    public synchronized String getName() {
        if (this.m_Name == null) {
            this.m_Name = this.createName();
        }
        return this.m_Name;
    }

    public boolean hasHeader() {
        return this.m_Header != null;
    }

    public Instances getHeader() {
        return this.m_Header;
    }

    public synchronized OutputTabbedPane getTabbedPane() {
        if (this.m_TabbedPane == null) {
            this.m_TabbedPane = new OutputTabbedPane();
            this.m_TabbedPane.setShowCloseTabButton(true);
            this.m_TabbedPane.setCloseTabsWithMiddleMouseButton(false);
        }
        return this.m_TabbedPane;
    }

    public SimpleLogPanel getLogPanel() {
        return this.m_LogPanel;
    }

    public void logMessage(String msg) {
        if (!msg.isEmpty()) {
            this.m_Log.append(msg);
            this.m_Log.append("\n");
            this.m_LogPanel.append(LoggingLevel.FINE, msg);
        }
    }

    public void logError(String msg, Throwable t) {
        String exc = Utils.throwableToString((Throwable)t);
        this.m_Log.append(msg);
        this.m_Log.append("\n");
        this.m_LogPanel.append(LoggingLevel.SEVERE, msg);
        this.m_Log.append(exc);
        this.m_Log.append("\n");
        this.m_LogPanel.append(LoggingLevel.SEVERE, exc);
    }

    public abstract String toString();

    public void cleanUp() {
        if (this.m_TabbedPane != null) {
            this.m_TabbedPane.cleanUp();
            this.m_TabbedPane = null;
        }
    }
}

