/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.CleanUpHandler;
import adams.core.MessageCollection;
import adams.core.StatusMessageHandler;
import adams.gui.core.DetachablePanel;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.event.WekaInvestigatorDataListener;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractInvestigatorTab
extends DetachablePanel
implements WekaInvestigatorDataListener,
StatusMessageHandler,
CleanUpHandler {
    private static final long serialVersionUID = 1860821657853747908L;
    protected InvestigatorPanel m_Owner;
    protected Thread m_Worker;

    protected void initialize() {
        super.initialize();
        this.m_Worker = null;
    }

    public void setOwner(InvestigatorPanel value) {
        this.m_Owner = value;
        this.dataChanged(new WekaInvestigatorDataEvent(this.m_Owner));
    }

    public InvestigatorPanel getOwner() {
        return this.m_Owner;
    }

    public abstract String getTitle();

    public String getTabIcon() {
        return null;
    }

    public List<DataContainer> getData() {
        return this.getOwner().getData();
    }

    public boolean isBusy() {
        return this.m_Worker != null;
    }

    public boolean canStartExecution() {
        return this.m_Worker == null;
    }

    protected void postStartExecution(InvestigatorTabJob job) {
    }

    public boolean startExecution(InvestigatorTabJob job) {
        if (!this.canStartExecution()) {
            this.logMessage("Busy, cannot start '" + job.getTitle() + "'!");
            return false;
        }
        this.m_Worker = new Thread(job);
        this.m_Worker.start();
        this.postStartExecution(job);
        return true;
    }

    protected void postStopExecution() {
    }

    public void stopExecution() {
        if (this.m_Worker == null) {
            return;
        }
        this.m_Worker.stop();
        this.m_Worker = null;
        this.postStopExecution();
    }

    protected void postExecutionFinished() {
    }

    public void executionFinished() {
        this.m_Worker = null;
        this.postExecutionFinished();
    }

    @Override
    public abstract void dataChanged(WekaInvestigatorDataEvent var1);

    public void fireDataChange(WekaInvestigatorDataEvent e) {
        this.getOwner().fireDataChange(e);
    }

    protected Map<String, Object> doSerialize() {
        return new HashMap<String, Object>();
    }

    public Object serialize() {
        Map<String, Object> data = this.doSerialize();
        return data.size() == 0 ? null : data;
    }

    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
    }

    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            this.doDeserialize((Map)data, errors);
        }
    }

    public void logMessage(String msg) {
        if (!msg.isEmpty()) {
            this.getOwner().logMessage("[" + this.getTitle() + "] " + msg);
        }
    }

    public void logError(String msg, Throwable t, String title) {
        this.getOwner().logError("[" + this.getTitle() + "] " + msg, t, title);
    }

    public void logError(String msg, String title) {
        this.getOwner().logError("[" + this.getTitle() + "] " + msg, title);
    }

    public void showStatus(String msg) {
        this.logMessage(msg);
        this.getOwner().showStatus("[" + this.getTitle() + "] " + msg);
    }
}

