/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.ListHelper;
import adams.core.logging.LoggingLevel;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.UndoEvent;
import adams.gui.event.UndoListener;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import adams.gui.tools.wekainvestigator.datatable.action.Save;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithDataTable;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitButton;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class AbstractInvestigatorTabWithEditableDataTable
extends AbstractInvestigatorTabWithDataTable
implements UndoListener {
    private static final long serialVersionUID = -94945456385486233L;
    protected JideButton m_ButtonActivate;
    protected JideButton m_ButtonRemove;
    protected JideSplitButton m_ButtonAction;
    protected JideButton m_ButtonUp;
    protected JideButton m_ButtonDown;
    protected JideButton m_ButtonUndo;
    protected List<AbstractEditableDataTableAction> m_Actions;

    @Override
    protected void initialize() {
        Class[] classes;
        super.initialize();
        this.m_Owner = null;
        this.m_Actions = new ArrayList<AbstractEditableDataTableAction>();
        for (Class cls : classes = AbstractEditableDataTableAction.getActions()) {
            try {
                AbstractEditableDataTableAction action = (AbstractEditableDataTableAction)((Object)cls.newInstance());
                action.setOwner(this);
                this.m_Actions.add(action);
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)LoggingLevel.SEVERE, "Failed to instantiate action: " + cls.getName(), (Throwable)e);
            }
        }
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ButtonActivate = new JideButton("Activate", (Icon)GUIHelper.getIcon((String)"location.png"));
        this.m_ButtonActivate.setButtonStyle(1);
        this.m_ButtonActivate.addActionListener(e -> this.activate(this.m_Table.getSelectedRow()));
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonActivate);
        this.m_ButtonRemove = new JideButton("Remove", (Icon)GUIHelper.getIcon((String)"delete.gif"));
        this.m_ButtonRemove.setButtonStyle(1);
        this.m_ButtonRemove.addActionListener(e -> this.removeData(this.m_Table.getSelectedRows()));
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_ButtonUndo = new JideButton("Undo", (Icon)GUIHelper.getIcon((String)"undo.gif"));
        this.m_ButtonUndo.setButtonStyle(1);
        this.m_ButtonUndo.addActionListener(e -> this.undo(this.m_Table.getSelectedRows()));
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonUndo);
        this.m_ButtonAction = new JideSplitButton();
        this.m_ButtonAction.setAlwaysDropdown(false);
        this.m_ButtonAction.setButtonEnabled(true);
        this.m_ButtonAction.setButtonStyle(1);
        for (AbstractEditableDataTableAction action : this.m_Actions) {
            if (action instanceof Save) {
                this.m_ButtonAction.setAction((Action)((Object)action));
                continue;
            }
            this.m_ButtonAction.add((Action)((Object)action));
        }
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonAction);
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.m_ButtonUp = new JideButton((Icon)GUIHelper.getIcon((String)"arrow_up.gif"));
        this.m_ButtonUp.setButtonStyle(1);
        this.m_ButtonUp.addActionListener(e -> {
            ListHelper.moveUp(this.getData(), (int[])this.getSelectedRows());
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1));
        });
        this.m_ButtonDown = new JideButton((Icon)GUIHelper.getIcon((String)"arrow_down.gif"));
        this.m_ButtonDown.setButtonStyle(1);
        this.m_ButtonDown.addActionListener(e -> {
            ListHelper.moveDown(this.getData(), (int[])this.getSelectedRows());
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1));
        });
        panel.add((Component)this.m_ButtonUp);
        panel.add((Component)this.m_ButtonDown);
        this.m_Table.addToButtonsPanel(panel);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    @Override
    protected boolean hasReadOnlyTable() {
        return false;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        super.dataChanged(e);
        for (DataContainer cont : this.getData()) {
            cont.getUndo().addUndoListener((UndoListener)this);
        }
        this.updateButtons();
    }

    @Override
    protected void dataTableSelectionChanged() {
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonActivate.setEnabled(!this.isBusy() && this.m_Table.getSelectedRowCount() == 1);
        this.m_ButtonRemove.setEnabled(!this.isBusy() && this.m_Table.getSelectedRowCount() > 0);
        for (AbstractEditableDataTableAction action : this.m_Actions) {
            action.update();
        }
        this.m_ButtonUp.setEnabled(!this.isBusy() && this.m_Model.canMoveUp(this.getSelectedRows()));
        this.m_ButtonDown.setEnabled(!this.isBusy() && this.m_Model.canMoveDown(this.getSelectedRows()));
        int[] rows = this.m_Table.getSelectedRows();
        boolean enabled = false;
        for (Object row : (Object)rows) {
            DataContainer cont;
            if (row >= this.getData().size() || !(cont = this.getData().get((int)row)).isUndoSupported() || !cont.getUndo().canUndo()) continue;
            enabled = true;
            break;
        }
        this.m_ButtonUndo.setEnabled(!this.isBusy() && enabled);
    }

    public void undoOccurred(UndoEvent e) {
        this.updateButtons();
    }
}

