/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.gui.core.SearchPanel;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithEditableDataTable;
import adams.gui.visualization.instances.InstancesTable;
import adams.gui.visualization.instances.InstancesTableModel;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataTab
extends AbstractInvestigatorTabWithEditableDataTable
implements ChangeListener {
    private static final long serialVersionUID = -94945456385486233L;
    protected Map<DataContainer, InstancesTable> m_TableCache;
    protected Map<DataContainer, Date> m_TimestampCache;
    protected Integer m_MaxColWidth;
    protected InstancesTable m_CurrentTable;
    protected SearchPanel m_PanelSearch;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_TableCache = new HashMap<DataContainer, InstancesTable>();
        this.m_TimestampCache = new HashMap<DataContainer, Date>();
        this.m_MaxColWidth = null;
        this.m_CurrentTable = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(e -> {
            if (this.m_CurrentTable != null) {
                if (e.getParameters().getSearchString().isEmpty()) {
                    this.m_CurrentTable.search(null, false);
                } else {
                    this.m_CurrentTable.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                }
            }
        });
    }

    @Override
    public String getTitle() {
        return "Data";
    }

    @Override
    public String getTabIcon() {
        return "spreadsheet.png";
    }

    @Override
    protected int getDataTableListSelectionMode() {
        return 2;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        InstancesTable table;
        super.dataChanged(e);
        HashSet<DataContainer> cached = new HashSet<DataContainer>(this.m_TableCache.keySet());
        HashSet<DataContainer> current = new HashSet<DataContainer>();
        for (DataContainer cont : this.getOwner().getData()) {
            current.add(cont);
        }
        cached.removeAll(current);
        for (DataContainer cont : cached) {
            table = this.m_TableCache.remove(cont);
            table.removeChangeListener(this);
            this.m_TimestampCache.remove(cont);
        }
        for (DataContainer cont : current) {
            if (!this.m_TimestampCache.containsKey(cont) || cont.lastUpdated().equals(this.m_TimestampCache.get(cont))) continue;
            table = this.m_TableCache.remove(cont);
            table.removeChangeListener(this);
            this.m_TimestampCache.remove(cont);
        }
        this.displayData();
    }

    @Override
    protected void dataTableSelectionChanged() {
        super.dataTableSelectionChanged();
        this.displayData();
    }

    protected void displayData() {
        if (this.m_MaxColWidth == null) {
            this.m_MaxColWidth = InvestigatorPanel.getProperties().getInteger("Data.MaxColWidth", Integer.valueOf(100));
        }
        if (this.m_Table.getRowCount() > 0 && this.m_Table.getSelectedRow() > -1) {
            boolean setOptimal;
            JPanel panel = new JPanel(new BorderLayout());
            int index = this.m_Table.getSelectedRow();
            DataContainer cont = this.getData().get(index);
            if (this.m_TableCache.containsKey(cont)) {
                this.m_CurrentTable = this.m_TableCache.get(cont);
                setOptimal = false;
            } else {
                InstancesTableModel model = new InstancesTableModel(cont.getData());
                model.setUndoHandler(this.getData().get(index));
                model.setShowAttributeIndex(true);
                this.m_CurrentTable = new InstancesTable(model);
                this.m_CurrentTable.setUndoEnabled(true);
                this.m_CurrentTable.addChangeListener(this);
                this.m_TableCache.put(cont, this.m_CurrentTable);
                this.m_TimestampCache.put(cont, new Date(cont.lastUpdated().getTime()));
                setOptimal = true;
            }
            panel.add((Component)new BaseScrollPane((Component)((Object)this.m_CurrentTable)), "Center");
            panel.add((Component)this.m_PanelSearch, "South");
            this.m_PanelData.removeAll();
            this.m_PanelData.add((Component)panel, "Center");
            if (this.m_SplitPane.isBottomComponentHidden()) {
                this.m_SplitPane.setDividerLocation(this.m_DefaultDataTableHeight);
                this.m_SplitPane.setBottomComponentHidden(false);
            }
            if (setOptimal) {
                this.m_CurrentTable.setOptimalColumnWidthBounded(this.m_MaxColWidth);
            }
        } else {
            this.m_PanelData.removeAll();
            this.m_SplitPane.setBottomComponentHidden(true);
        }
        this.invalidate();
        this.revalidate();
        this.doLayout();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.getSelectedRows().length > 0) {
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 4, this.getSelectedRows()[0]));
        } else {
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1));
        }
    }
}

