/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Range;
import adams.data.instance.Instance;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.core.SearchPanel;
import adams.gui.core.SearchableBaseList;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.visualization.core.PaintletWithMarkers;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.core.Instances;

public class InstanceTab
extends AbstractInvestigatorTab {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final String KEY_LEFTPANELWIDTH = "leftpanelwidth";
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_ID = "id";
    public static final String KEY_RANGE = "range";
    public static final String KEY_ANTIALIASING = "antialiasing";
    public static final String KEY_MARKERS = "markers";
    public static final String KEY_IDS = "ids";
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PanelLeft;
    protected JPanel m_PanelRight;
    protected ParameterPanel m_PanelParameters;
    protected DefaultComboBoxModel<String> m_ModelAttributes;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected JComboBox<String> m_ComboBoxDatasets;
    protected JComboBox<String> m_ComboBoxID;
    protected JTextField m_TextAttributeRange;
    protected JCheckBox m_CheckBoxAntiAliasing;
    protected JCheckBox m_CheckBoxMarkers;
    protected DefaultListModel<Comparable> m_ModelIDs;
    protected SearchableBaseList m_ListIDs;
    protected SearchPanel m_PanelSearchID;
    protected JButton m_ButtonVisualize;
    protected InstancePanel m_PanelInstance;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ModelAttributes = new DefaultComboBoxModel();
        this.m_ModelIDs = new DefaultListModel();
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setDividerLocation(props.getInteger("Instance.LeftPanelWidth", Integer.valueOf(200)).intValue());
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_ContentPanel.add((Component)this.m_SplitPane, (Object)"Center");
        this.m_PanelLeft = new JPanel(new BorderLayout());
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)this.m_PanelLeft);
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        JPanel panelOptions = new JPanel(new BorderLayout());
        this.m_PanelLeft.add((Component)panelOptions, "North");
        this.m_PanelParameters = new ParameterPanel();
        panelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ComboBoxDatasets = new JComboBox<String>(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.updateAttributes());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_ComboBoxID = new JComboBox<String>(this.m_ModelAttributes);
        this.m_ComboBoxID.addActionListener(e -> this.updateIDs());
        this.m_PanelParameters.addParameter("ID", this.m_ComboBoxID);
        this.m_TextAttributeRange = new JTextField(20);
        this.m_TextAttributeRange.setText("first-last");
        this.m_TextAttributeRange.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                InstanceTab.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InstanceTab.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InstanceTab.this.updateButtons();
            }
        });
        this.m_PanelParameters.addParameter("Range", (Component)this.m_TextAttributeRange);
        this.m_CheckBoxAntiAliasing = new JCheckBox();
        this.m_CheckBoxAntiAliasing.setSelected(props.getBoolean("Instance.AntiAliasing", Boolean.valueOf(true)));
        this.m_PanelParameters.addParameter("Use anti-aliasing", (Component)this.m_CheckBoxAntiAliasing);
        this.m_CheckBoxMarkers = new JCheckBox();
        this.m_CheckBoxMarkers.setSelected(props.getBoolean("Instance.Markers", Boolean.valueOf(true)));
        this.m_PanelParameters.addParameter("Use makers", (Component)this.m_CheckBoxMarkers);
        JPanel panelIDs = new JPanel(new BorderLayout(5, 5));
        panelIDs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_PanelLeft.add((Component)panelIDs, "Center");
        this.m_ListIDs = new SearchableBaseList(this.m_ModelIDs);
        this.m_PanelSearchID = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
        this.m_PanelSearchID.addSearchListener(e -> this.m_ListIDs.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
        panelIDs.add((Component)new JLabel("Instances to display"), "North");
        panelIDs.add((Component)new BaseScrollPane((Component)this.m_ListIDs), "Center");
        panelIDs.add((Component)this.m_PanelSearchID, "South");
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        this.m_PanelLeft.add((Component)panelButtons, "South");
        this.m_ButtonVisualize = new JButton("Visualize");
        this.m_ButtonVisualize.setMnemonic('V');
        this.m_ButtonVisualize.addActionListener(e -> this.visualize());
        panelButtons.add(this.m_ButtonVisualize);
        this.m_PanelInstance = new InstancePanel();
        this.m_PanelInstance.setZoomOverviewPanelVisible(true);
        this.m_PanelInstance.setSidePanelVisible(false);
        this.m_PanelRight.add((Component)((Object)this.m_PanelInstance), "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    @Override
    public String getTitle() {
        return "Instance";
    }

    @Override
    public String getTabIcon() {
        return "chart.gif";
    }

    protected int indexOfDataset(String oldDataset) {
        int result = -1;
        if (oldDataset != null) {
            oldDataset = oldDataset.replaceAll("^[0-9]+: ", "");
        }
        for (int i = 0; i < this.getOwner().getData().size(); ++i) {
            DataContainer data = this.getOwner().getData().get(i);
            if (oldDataset == null || !data.getData().relationName().equals(oldDataset)) continue;
            result = i;
            break;
        }
        return result;
    }

    protected boolean hasDataChanged(List<String> newDatasets, ComboBoxModel<String> currentModel) {
        int index;
        boolean result;
        HashSet<String> setDatasets = new HashSet<String>(newDatasets);
        HashSet setModel = new HashSet();
        for (int i = 0; i < currentModel.getSize(); ++i) {
            setModel.add(currentModel.getElementAt(i));
        }
        boolean bl = result = setDatasets.size() != setModel.size() || !setDatasets.containsAll(setModel) || !setModel.containsAll(setDatasets);
        if (!result && (index = this.indexOfDataset((String)this.m_ComboBoxDatasets.getSelectedItem())) > -1 && this.getData().get(index).getData().numAttributes() != this.m_ComboBoxID.getModel().getSize() - 1) {
            result = true;
        }
        return result;
    }

    protected List<String> generateDatasetList() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getOwner().getData().size(); ++i) {
            DataContainer data = this.getOwner().getData().get(i);
            result.add(i + 1 + ": " + data.getData().relationName());
        }
        return result;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        if (e.getType() == 5) {
            this.m_ComboBoxDatasets.setSelectedIndex(e.getRows()[0]);
            return;
        }
        List<String> datasets = this.generateDatasetList();
        int index = this.indexOfDataset((String)this.m_ComboBoxDatasets.getSelectedItem());
        if (this.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelIDs.clear();
            this.m_ModelAttributes.removeAllElements();
            this.m_PanelInstance.getSequenceManager().clear();
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.updateButtons();
    }

    protected void updateAttributes() {
        this.m_ModelAttributes.removeAllElements();
        if (this.m_ComboBoxDatasets.getSelectedIndex() == -1) {
            return;
        }
        if (this.m_ComboBoxDatasets.getSelectedIndex() > this.getData().size() - 1) {
            return;
        }
        String oldID = (String)this.m_ComboBoxID.getSelectedItem();
        Instances data = this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ArrayList<String> atts = new ArrayList<String>();
        atts.add("-none-");
        for (int i = 0; i < data.numAttributes(); ++i) {
            atts.add(i + 1 + ": " + data.attribute(i).name());
        }
        this.m_ModelAttributes = new DefaultComboBoxModel<String>(atts.toArray(new String[atts.size()]));
        int indexID = this.m_ModelAttributes.getIndexOf(oldID);
        this.m_ComboBoxID.setModel(this.m_ModelAttributes);
        if (indexID == -1) {
            this.m_ComboBoxID.setSelectedIndex(0);
        } else {
            this.m_ComboBoxID.setSelectedIndex(indexID);
        }
    }

    protected void updateIDs() {
        this.m_ModelIDs.clear();
        if (this.m_ComboBoxDatasets.getSelectedIndex() == -1) {
            return;
        }
        if (this.m_ComboBoxDatasets.getSelectedIndex() > this.getData().size() - 1) {
            return;
        }
        Instances data = this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ArrayList<Object> ids = new ArrayList<Object>();
        int indexID = this.m_ComboBoxID.getSelectedIndex() - 1;
        for (int i = 0; i < data.numInstances(); ++i) {
            if (indexID > -1) {
                weka.core.Instance inst = data.instance(i);
                if (inst.attribute(indexID).isNumeric()) {
                    ids.add(inst.value(indexID));
                    continue;
                }
                ids.add(inst.stringValue(indexID));
                continue;
            }
            ids.add(i + 1);
        }
        if (indexID > -1) {
            Collections.sort(ids);
        }
        this.m_ModelIDs = new DefaultListModel();
        for (Comparable comparable : ids) {
            this.m_ModelIDs.addElement(comparable);
        }
        this.m_ListIDs.setModel(this.m_ModelIDs);
    }

    protected String canVisualize() {
        Instances data = this.m_ComboBoxDatasets.getSelectedIndex() > -1 ? this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData() : null;
        if (data == null) {
            return "No data available!";
        }
        String rangeStr = this.m_TextAttributeRange.getText();
        if (rangeStr.isEmpty()) {
            return "No attribute range defined!";
        }
        if (!Range.isValid((String)rangeStr, (int)data.numAttributes())) {
            return "Invalid attribute range!";
        }
        return null;
    }

    protected void updateButtons() {
        String msg = this.canVisualize();
        this.m_ButtonVisualize.setEnabled(msg == null);
        this.m_ButtonVisualize.setToolTipText(msg);
    }

    protected void visualize() {
        if (this.m_ComboBoxDatasets.getSelectedIndex() == -1) {
            return;
        }
        Instances data = this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Range range = new Range(this.m_TextAttributeRange.getText());
        int indexID = this.m_ComboBoxID.getSelectedIndex() - 1;
        HashSet<Integer> attTypes = new HashSet<Integer>();
        attTypes.add(0);
        boolean numericID = false;
        TIntArrayList additional = new TIntArrayList();
        if (indexID > -1) {
            additional.add(indexID);
            numericID = data.attribute(indexID).isNumeric();
        }
        HashSet<Comparable> ids = null;
        int[] sel = this.m_ListIDs.getSelectedIndices();
        if (sel.length > 0) {
            ids = new HashSet<Comparable>();
            for (int s : sel) {
                ids.add(this.m_ModelIDs.get(s));
            }
        }
        InstanceContainerManager manager = (InstanceContainerManager)this.m_PanelInstance.getContainerManager();
        manager.clear();
        this.m_PanelInstance.setAntiAliasingEnabled(this.m_CheckBoxAntiAliasing.isSelected());
        if (this.m_PanelInstance.getDataPaintlet() instanceof PaintletWithMarkers) {
            ((PaintletWithMarkers)this.m_PanelInstance.getDataPaintlet()).setMarkersDisabled(!this.m_CheckBoxMarkers.isSelected());
        }
        manager.startUpdate();
        for (int i = 0; i < data.numInstances(); ++i) {
            Object id;
            weka.core.Instance winst = data.instance(i);
            if (ids != null && (indexID > -1 ? !ids.contains(id = numericID ? Double.valueOf(winst.value(indexID)) : winst.stringValue(indexID)) : !ids.contains(i + 1))) continue;
            Instance ainst = new Instance();
            ainst.set(winst, i, additional.toArray(), range, attTypes);
            InstanceContainer cont = manager.newContainer((Comparable)((Object)ainst));
            if (indexID > -1) {
                if (numericID) {
                    cont.setID("" + winst.value(indexID));
                } else {
                    cont.setID(winst.stringValue(indexID));
                }
            }
            manager.add(cont);
        }
        manager.finishUpdate();
    }

    @Override
    protected Map<String, Object> doSerialize() {
        Map<String, Object> result = super.doSerialize();
        result.put(KEY_LEFTPANELWIDTH, this.m_SplitPane.getDividerLocation());
        result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        result.put(KEY_ID, this.m_ComboBoxID.getSelectedIndex());
        result.put(KEY_RANGE, this.m_TextAttributeRange.getText());
        result.put(KEY_ANTIALIASING, this.m_CheckBoxAntiAliasing.isSelected());
        result.put(KEY_MARKERS, this.m_CheckBoxMarkers.isSelected());
        result.put(KEY_IDS, this.m_ListIDs.getSelectedIndices());
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_LEFTPANELWIDTH)) {
            this.m_SplitPane.setDividerLocation(((Integer)data.get(KEY_LEFTPANELWIDTH)).intValue());
        }
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex((Integer)data.get(KEY_DATASET));
        }
        if (data.containsKey(KEY_ID)) {
            this.m_ComboBoxID.setSelectedIndex((Integer)data.get(KEY_ID));
        }
        if (data.containsKey(KEY_RANGE)) {
            this.m_TextAttributeRange.setText((String)data.get(KEY_RANGE));
        }
        if (data.containsKey(KEY_ANTIALIASING)) {
            this.m_CheckBoxAntiAliasing.setSelected((Boolean)data.get(KEY_ANTIALIASING));
        }
        if (data.containsKey(KEY_MARKERS)) {
            this.m_CheckBoxMarkers.setSelected((Boolean)data.get(KEY_MARKERS));
        }
        if (data.containsKey(KEY_IDS)) {
            this.m_ListIDs.setSelectedIndices((int[])data.get(KEY_IDS));
        }
    }
}

