/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.CleanUpHandler;
import adams.gui.core.ButtonTabComponent;
import adams.gui.core.DragAndDropTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import java.awt.Component;

public class InvestigatorTabbedPane
extends DragAndDropTabbedPane
implements CleanUpHandler {
    private static final long serialVersionUID = -8555377473460866456L;
    protected InvestigatorPanel m_Owner;

    public InvestigatorTabbedPane(InvestigatorPanel owner) {
        this.m_Owner = owner;
        this.setCloseTabsWithMiddleMouseButton(true);
        this.setShowCloseTabButton(true);
        this.setPromptUserWhenClosingTab(true);
    }

    public InvestigatorPanel getOwner() {
        return this.m_Owner;
    }

    public void addTab(AbstractInvestigatorTab tab) {
        this.addTab(tab, false);
    }

    public void addTab(AbstractInvestigatorTab tab, boolean show) {
        tab.setOwner(this.getOwner());
        tab.setFrameTitle(tab.getTitle());
        this.addTab(tab.getTitle(), (Component)((Object)tab));
        ButtonTabComponent button = (ButtonTabComponent)this.getTabComponentAt(this.getTabCount() - 1);
        button.setIcon(tab.getTabIcon() == null ? null : GUIHelper.getIcon((String)tab.getTabIcon()));
        if (show) {
            this.setSelectedIndex(this.getTabCount() - 1);
        }
    }

    public void removeTabAt(int index) {
        Component comp = this.getComponentAt(index);
        super.removeTabAt(index);
        if (!this.m_MovingTab && comp instanceof CleanUpHandler) {
            ((CleanUpHandler)comp).cleanUp();
        }
    }

    public void cleanUp() {
        this.removeAll();
    }
}

