/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.Index;
import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Range;
import adams.core.option.OptionUtils;
import adams.data.container.DataPoint;
import adams.data.instancesanalysis.PLS;
import adams.data.instancesanalysis.pls.AbstractPLS;
import adams.data.instancesanalysis.pls.PLS1;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.weka.WekaAttributeRange;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ParameterPanel;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.Coordinates;
import adams.gui.visualization.stats.scatterplot.ScatterPlot;
import adams.gui.visualization.stats.scatterplot.action.MouseClickAction;
import adams.gui.visualization.stats.scatterplot.action.ViewDataClickAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.core.Instances;

public class PartialLeastSquaresTab
extends AbstractInvestigatorTab {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final String KEY_LEFTPANELWIDTH = "leftpanelwidth";
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_RANGE = "range";
    public static final String KEY_ALGORITHM = "algorithm";
    public static final String KEY_COMPONENTS = "components";
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PanelLeft;
    protected JPanel m_PanelRight;
    protected ParameterPanel m_PanelParameters;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected JComboBox<String> m_ComboBoxDatasets;
    protected JTextField m_TextAttributeRange;
    protected GenericObjectEditorPanel m_PanelGOE;
    protected JButton m_ButtonStart;
    protected JButton m_ButtonStop;
    protected BaseTabbedPane m_TabbedPanePlots;
    protected ScatterPlot m_PanelLoadings;
    protected ScatterPlot m_PanelScores;
    protected SequencePlotterPanel m_PanelWeights;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ModelDatasets = new DefaultComboBoxModel();
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setDividerLocation(props.getInteger("PartialLeastSquares.LeftPanelWidth", Integer.valueOf(200)).intValue());
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_ContentPanel.add((Component)this.m_SplitPane, (Object)"Center");
        this.m_PanelLeft = new JPanel(new BorderLayout());
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)this.m_PanelLeft);
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        JPanel panelOptions = new JPanel(new BorderLayout());
        this.m_PanelLeft.add((Component)panelOptions, "North");
        this.m_PanelParameters = new ParameterPanel();
        panelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ComboBoxDatasets = new JComboBox<String>(this.m_ModelDatasets);
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_TextAttributeRange = new JTextField(20);
        this.m_TextAttributeRange.setText("first-last");
        this.m_TextAttributeRange.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PartialLeastSquaresTab.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PartialLeastSquaresTab.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PartialLeastSquaresTab.this.updateButtons();
            }
        });
        this.m_PanelParameters.addParameter("Range", (Component)this.m_TextAttributeRange);
        this.m_PanelGOE = new GenericObjectEditorPanel(AbstractPLS.class, (Object)new PLS1(), true);
        this.m_PanelParameters.addParameter("Algorithm", (Component)this.m_PanelGOE);
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        panelOptions.add((Component)panelButtons, "South");
        this.m_ButtonStart = new JButton("Start");
        this.m_ButtonStart.addActionListener(e -> this.startExecution());
        panelButtons.add(this.m_ButtonStart);
        this.m_ButtonStop = new JButton("Stop");
        this.m_ButtonStop.addActionListener(e -> this.stopExecution());
        panelButtons.add(this.m_ButtonStop);
        this.m_TabbedPanePlots = new BaseTabbedPane();
        this.m_PanelRight.add((Component)this.m_TabbedPanePlots, "Center");
        this.m_PanelLoadings = new ScatterPlot();
        this.m_PanelLoadings.setXIndex(new Index("1"));
        this.m_PanelLoadings.setYIndex(new Index("2"));
        this.m_PanelLoadings.getPlot().getAxis(Axis.LEFT).setTopMargin(0.01);
        this.m_PanelLoadings.getPlot().getAxis(Axis.LEFT).setBottomMargin(0.01);
        this.m_PanelLoadings.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        this.m_PanelLoadings.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        this.m_PanelLoadings.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        this.m_PanelLoadings.setOverlays(new AbstractScatterPlotOverlay[]{new Coordinates()});
        this.m_TabbedPanePlots.addTab("Loadings", (Component)this.m_PanelLoadings);
        this.m_PanelWeights = new SequencePlotterPanel("Weights");
        this.m_PanelWeights.setDataPaintlet((Paintlet)new LinePaintlet());
        AxisPanel axis = this.m_PanelWeights.getPlot().getAxis(Axis.BOTTOM);
        axis.setAxisName("attribute");
        axis.setNumberFormat("0");
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(40);
        axis.setTickGenerator((TickGenerator)tick);
        axis.setNthValueToShow(4);
        axis = this.m_PanelWeights.getPlot().getAxis(Axis.LEFT);
        axis.setAxisName("weight");
        axis.setNumberFormat("0.000");
        tick = new FancyTickGenerator();
        tick.setNumTicks(20);
        axis.setTickGenerator((TickGenerator)tick);
        axis.setNthValueToShow(2);
        this.m_TabbedPanePlots.addTab("Weights", (Component)this.m_PanelWeights);
        this.m_PanelScores = new ScatterPlot();
        this.m_PanelScores.setXIndex(new Index("1"));
        this.m_PanelScores.setYIndex(new Index("2"));
        this.m_PanelScores.getPlot().getAxis(Axis.LEFT).setTopMargin(0.01);
        this.m_PanelScores.getPlot().getAxis(Axis.LEFT).setBottomMargin(0.01);
        this.m_PanelScores.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        this.m_PanelScores.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        this.m_PanelScores.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        this.m_PanelScores.setOverlays(new AbstractScatterPlotOverlay[]{new Coordinates()});
        this.m_TabbedPanePlots.addTab("Scores", (Component)this.m_PanelScores);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    @Override
    public String getTitle() {
        return "PLS";
    }

    @Override
    public String getTabIcon() {
        return "scatterplot.gif";
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        if (e.getType() == 5) {
            this.m_ComboBoxDatasets.setSelectedIndex(e.getRows()[0]);
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(this.getData());
        int index = DatasetHelper.indexOfDataset(this.getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.updateButtons();
    }

    @Override
    public boolean isBusy() {
        return this.m_Worker != null;
    }

    protected String canVisualize() {
        String rangeStr = this.m_TextAttributeRange.getText();
        Instances data = this.m_ComboBoxDatasets.getSelectedIndex() > -1 ? this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData() : null;
        if (this.isBusy()) {
            return "Currently busy...";
        }
        if (data == null) {
            return "No data selected!";
        }
        if (data.classIndex() == -1) {
            return "No class attribute present!";
        }
        if (rangeStr.isEmpty()) {
            return "No attribute range provided!";
        }
        if (!Range.isValid((String)rangeStr, (int)data.numAttributes())) {
            return "Invalid attribute range!";
        }
        return null;
    }

    protected void updateButtons() {
        String msg = this.canVisualize();
        this.m_ButtonStart.setEnabled(msg == null);
        this.m_ButtonStart.setToolTipText(msg);
        this.m_ButtonStop.setEnabled(this.isBusy());
    }

    protected void startExecution() {
        this.startExecution(new InvestigatorTabJob(this, "PLS visualization"){

            @Override
            protected void doRun() {
                try {
                    DataContainer datacont = PartialLeastSquaresTab.this.getData().get(PartialLeastSquaresTab.this.m_ComboBoxDatasets.getSelectedIndex());
                    PLS pls = new PLS();
                    pls.setAttributeRange(new WekaAttributeRange(PartialLeastSquaresTab.this.m_TextAttributeRange.getText()));
                    pls.setAlgorithm((AbstractPLS)PartialLeastSquaresTab.this.m_PanelGOE.getCurrent());
                    String msg = pls.analyze(datacont.getData());
                    if (msg != null) {
                        PartialLeastSquaresTab.this.logError(msg, "PLS Error");
                    } else {
                        SpreadSheet loadings = pls.getLoadings();
                        PartialLeastSquaresTab.this.m_PanelLoadings.setData(loadings);
                        PartialLeastSquaresTab.this.m_PanelLoadings.reset();
                        XYSequenceContainerManager manager = (XYSequenceContainerManager)PartialLeastSquaresTab.this.m_PanelWeights.getContainerManager();
                        double min = Double.POSITIVE_INFINITY;
                        double max = Double.NEGATIVE_INFINITY;
                        manager.clear();
                        manager.startUpdate();
                        for (int c = 0; c < loadings.getColumnCount(); ++c) {
                            XYSequence seq = new XYSequence();
                            seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
                            seq.setID(loadings.getColumnName(c));
                            XYSequenceContainer cont = manager.newContainer((Comparable)seq);
                            manager.add(cont);
                            for (int r = 0; r < loadings.getRowCount(); ++r) {
                                DataRow row = loadings.getRow(r);
                                double value = row.getCell(c).toDouble();
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                                XYSequencePoint point = new XYSequencePoint("" + seq.size(), (double)seq.size(), value);
                                seq.add((DataPoint)point);
                            }
                        }
                        manager.finishUpdate();
                        PartialLeastSquaresTab.this.m_PanelScores.setData(pls.getScores());
                        PartialLeastSquaresTab.this.m_PanelScores.reset();
                    }
                }
                catch (Throwable t) {
                    PartialLeastSquaresTab.this.logError("Failed to perform PLS!", t, "PLS error");
                }
            }
        });
    }

    @Override
    protected void postStartExecution(InvestigatorTabJob job) {
        super.postStartExecution(job);
        this.updateButtons();
    }

    @Override
    protected void postStopExecution() {
        super.postStopExecution();
        this.logMessage("Stopped PLS visualization");
        this.updateButtons();
    }

    @Override
    protected void postExecutionFinished() {
        super.postExecutionFinished();
        this.updateButtons();
    }

    @Override
    protected Map<String, Object> doSerialize() {
        Map<String, Object> result = super.doSerialize();
        result.put(KEY_LEFTPANELWIDTH, this.m_SplitPane.getDividerLocation());
        result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        result.put(KEY_RANGE, this.m_TextAttributeRange.getText());
        result.put(KEY_ALGORITHM, OptionUtils.getCommandLine((Object)this.m_PanelGOE.getCurrent()));
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_LEFTPANELWIDTH)) {
            this.m_SplitPane.setDividerLocation(((Integer)data.get(KEY_LEFTPANELWIDTH)).intValue());
        }
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex((Integer)data.get(KEY_DATASET));
        }
        if (data.containsKey(KEY_RANGE)) {
            this.m_TextAttributeRange.setText((String)data.get(KEY_RANGE));
        }
        if (data.containsKey(KEY_ALGORITHM)) {
            try {
                this.m_PanelGOE.setCurrent(OptionUtils.forAnyCommandLine(AbstractPLS.class, (String)((String)data.get(KEY_ALGORITHM))));
            }
            catch (Exception e) {
                this.m_PanelGOE.setCurrent((Object)new PLS1());
            }
        }
    }
}

