/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.Index;
import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Range;
import adams.core.base.BaseRegExp;
import adams.data.instancesanalysis.PCA;
import adams.data.weka.WekaAttributeRange;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.Coordinates;
import adams.gui.visualization.stats.scatterplot.ScatterPlot;
import adams.gui.visualization.stats.scatterplot.action.MouseClickAction;
import adams.gui.visualization.stats.scatterplot.action.ViewDataClickAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.core.Instances;

public class PrincipalComponentsTab
extends AbstractInvestigatorTab {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final String KEY_LEFTPANELWIDTH = "leftpanelwidth";
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_RANGE = "range";
    public static final String KEY_VARIANCE = "variance";
    public static final String KEY_MAXATTRIBUTES = "maxattributes";
    public static final String KEY_MAXATTRIBUTENAMES = "maxattributenames";
    public static final String KEY_SKIPNOMINAL = "skipnominal";
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PanelLeft;
    protected JPanel m_PanelRight;
    protected ParameterPanel m_PanelParameters;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected JComboBox<String> m_ComboBoxDatasets;
    protected JTextField m_TextAttributeRange;
    protected NumberTextField m_TextVariance;
    protected NumberTextField m_TextMaxAttributes;
    protected NumberTextField m_TextMaxAttributeNames;
    protected JCheckBox m_CheckBoxSkipNominal;
    protected JButton m_ButtonStart;
    protected JButton m_ButtonStop;
    protected BaseTabbedPane m_TabbedPanePlots;
    protected ScatterPlot m_PanelLoadings;
    protected ScatterPlot m_PanelScores;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ModelDatasets = new DefaultComboBoxModel();
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setDividerLocation(props.getInteger("PrincipalComponents.LeftPanelWidth", Integer.valueOf(200)).intValue());
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_ContentPanel.add((Component)this.m_SplitPane, (Object)"Center");
        this.m_PanelLeft = new JPanel(new BorderLayout());
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)this.m_PanelLeft);
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        JPanel panelOptions = new JPanel(new BorderLayout());
        this.m_PanelLeft.add((Component)panelOptions, "North");
        this.m_PanelParameters = new ParameterPanel();
        panelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ComboBoxDatasets = new JComboBox<String>(this.m_ModelDatasets);
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_TextAttributeRange = new JTextField(20);
        this.m_TextAttributeRange.setText("first-last");
        this.m_TextAttributeRange.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PrincipalComponentsTab.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PrincipalComponentsTab.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PrincipalComponentsTab.this.updateButtons();
            }
        });
        this.m_PanelParameters.addParameter("Range", (Component)this.m_TextAttributeRange);
        this.m_TextVariance = new NumberTextField(NumberTextField.Type.DOUBLE, 10);
        this.m_TextVariance.setValue((Number)props.getDouble("PrincipalComponents.Variance", Double.valueOf(0.95)));
        this.m_PanelParameters.addParameter("Variance", (Component)this.m_TextVariance);
        this.m_TextMaxAttributes = new NumberTextField(NumberTextField.Type.INTEGER, 10);
        this.m_TextMaxAttributes.setValue((Number)props.getInteger("PrincipalComponents.MaxAttributes", Integer.valueOf(-1)));
        this.m_PanelParameters.addParameter("Max attributes", (Component)this.m_TextMaxAttributes);
        this.m_TextMaxAttributeNames = new NumberTextField(NumberTextField.Type.INTEGER, 10);
        this.m_TextMaxAttributeNames.setValue((Number)props.getInteger("PrincipalComponents.MaxAttributeNames", Integer.valueOf(5)));
        this.m_PanelParameters.addParameter("Max attribute names", (Component)this.m_TextMaxAttributeNames);
        this.m_CheckBoxSkipNominal = new JCheckBox();
        this.m_CheckBoxSkipNominal.setSelected(props.getBoolean("PrincipalComponents.SkipNominal", Boolean.valueOf(false)));
        this.m_PanelParameters.addParameter("Skip nominal attributes", (Component)this.m_CheckBoxSkipNominal);
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        panelOptions.add((Component)panelButtons, "South");
        this.m_ButtonStart = new JButton("Start");
        this.m_ButtonStart.addActionListener(e -> this.startExecution());
        panelButtons.add(this.m_ButtonStart);
        this.m_ButtonStop = new JButton("Stop");
        this.m_ButtonStop.addActionListener(e -> this.stopExecution());
        panelButtons.add(this.m_ButtonStop);
        this.m_TabbedPanePlots = new BaseTabbedPane();
        this.m_PanelRight.add((Component)this.m_TabbedPanePlots, "Center");
        this.m_PanelLoadings = new ScatterPlot();
        this.m_PanelLoadings.setXRegExp(new BaseRegExp("Loading-1"));
        this.m_PanelLoadings.setYRegExp(new BaseRegExp("Loading-2"));
        this.m_PanelLoadings.getPlot().getAxis(Axis.LEFT).setTopMargin(0.01);
        this.m_PanelLoadings.getPlot().getAxis(Axis.LEFT).setBottomMargin(0.01);
        this.m_PanelLoadings.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        this.m_PanelLoadings.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        this.m_PanelLoadings.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        this.m_PanelLoadings.setOverlays(new AbstractScatterPlotOverlay[]{new Coordinates()});
        this.m_TabbedPanePlots.addTab("Loadings", (Component)this.m_PanelLoadings);
        this.m_PanelScores = new ScatterPlot();
        this.m_PanelScores.setXIndex(new Index("1"));
        this.m_PanelScores.setYIndex(new Index("2"));
        this.m_PanelScores.getPlot().getAxis(Axis.LEFT).setTopMargin(0.01);
        this.m_PanelScores.getPlot().getAxis(Axis.LEFT).setBottomMargin(0.01);
        this.m_PanelScores.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        this.m_PanelScores.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        this.m_PanelScores.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        this.m_PanelScores.setOverlays(new AbstractScatterPlotOverlay[]{new Coordinates()});
        this.m_TabbedPanePlots.addTab("Scores", (Component)this.m_PanelScores);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    @Override
    public String getTitle() {
        return "PCA";
    }

    @Override
    public String getTabIcon() {
        return "scatterplot.gif";
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        if (e.getType() == 5) {
            this.m_ComboBoxDatasets.setSelectedIndex(e.getRows()[0]);
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(this.getData());
        int index = DatasetHelper.indexOfDataset(this.getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.updateButtons();
    }

    @Override
    public boolean isBusy() {
        return this.m_Worker != null;
    }

    protected String canVisualize() {
        String rangeStr = this.m_TextAttributeRange.getText();
        Instances data = this.m_ComboBoxDatasets.getSelectedIndex() > -1 ? this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData() : null;
        if (this.isBusy()) {
            return "Currently busy...";
        }
        if (data == null) {
            return "No data selected!";
        }
        if (rangeStr.isEmpty()) {
            return "No attribute range provided!";
        }
        if (!Range.isValid((String)rangeStr, (int)data.numAttributes())) {
            return "Invalid attribute range!";
        }
        return null;
    }

    protected void updateButtons() {
        String msg = this.canVisualize();
        this.m_ButtonStart.setEnabled(msg == null);
        this.m_ButtonStart.setToolTipText(msg);
        this.m_ButtonStop.setEnabled(this.isBusy());
    }

    protected void startExecution() {
        this.startExecution(new InvestigatorTabJob(this, "PCA visualization"){

            @Override
            protected void doRun() {
                DataContainer cont = PrincipalComponentsTab.this.getData().get(PrincipalComponentsTab.this.m_ComboBoxDatasets.getSelectedIndex());
                PCA pca = new PCA();
                pca.setAttributeRange(new WekaAttributeRange(PrincipalComponentsTab.this.m_TextAttributeRange.getText()));
                pca.setVariance(PrincipalComponentsTab.this.m_TextVariance.getValue().doubleValue());
                pca.setMaxAttributes(PrincipalComponentsTab.this.m_TextMaxAttributes.getValue().intValue());
                pca.setMaxAttributeNames(PrincipalComponentsTab.this.m_TextMaxAttributeNames.getValue().intValue());
                pca.setSkipNominal(PrincipalComponentsTab.this.m_CheckBoxSkipNominal.isSelected());
                String result = pca.analyze(cont.getData());
                if (result != null) {
                    PrincipalComponentsTab.this.logError(result, "PCA error");
                } else {
                    PrincipalComponentsTab.this.m_PanelLoadings.setData(pca.getLoadings());
                    PrincipalComponentsTab.this.m_PanelLoadings.reset();
                    PrincipalComponentsTab.this.m_PanelScores.setData(pca.getScores());
                    PrincipalComponentsTab.this.m_PanelScores.reset();
                }
            }
        });
    }

    @Override
    protected void postStartExecution(InvestigatorTabJob job) {
        super.postStartExecution(job);
        this.updateButtons();
    }

    @Override
    protected void postStopExecution() {
        super.postStopExecution();
        this.logMessage("Stopped PCA visualization");
        this.updateButtons();
    }

    @Override
    protected void postExecutionFinished() {
        super.postExecutionFinished();
        this.updateButtons();
    }

    @Override
    protected Map<String, Object> doSerialize() {
        Map<String, Object> result = super.doSerialize();
        result.put(KEY_LEFTPANELWIDTH, this.m_SplitPane.getDividerLocation());
        result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        result.put(KEY_RANGE, this.m_TextAttributeRange.getText());
        result.put(KEY_VARIANCE, this.m_TextVariance.getValue().doubleValue());
        result.put(KEY_MAXATTRIBUTES, this.m_TextMaxAttributes.getValue().intValue());
        result.put(KEY_MAXATTRIBUTENAMES, this.m_TextMaxAttributeNames.getValue().intValue());
        result.put(KEY_SKIPNOMINAL, this.m_CheckBoxSkipNominal.isSelected());
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_LEFTPANELWIDTH)) {
            this.m_SplitPane.setDividerLocation(((Integer)data.get(KEY_LEFTPANELWIDTH)).intValue());
        }
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex((Integer)data.get(KEY_DATASET));
        }
        if (data.containsKey(KEY_RANGE)) {
            this.m_TextAttributeRange.setText((String)data.get(KEY_RANGE));
        }
        if (data.containsKey(KEY_VARIANCE)) {
            this.m_TextVariance.setValue((Number)((Double)data.get(KEY_VARIANCE)));
        }
        if (data.containsKey(KEY_MAXATTRIBUTES)) {
            this.m_TextMaxAttributes.setValue((Number)((Integer)data.get(KEY_MAXATTRIBUTES)));
        }
        if (data.containsKey(KEY_MAXATTRIBUTENAMES)) {
            this.m_TextMaxAttributeNames.setValue((Number)((Integer)data.get(KEY_MAXATTRIBUTENAMES)));
        }
        if (data.containsKey(KEY_SKIPNOMINAL)) {
            this.m_CheckBoxSkipNominal.setSelected((Boolean)data.get(KEY_MAXATTRIBUTENAMES));
        }
    }
}

