/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab;

import adams.core.DateUtils;
import adams.core.Shortening;
import adams.data.spreadsheet.MetaData;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.wekainvestigator.output.AbstractResultItem;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class ResultItem
extends AbstractResultItem {
    private static final long serialVersionUID = -3409493446200539772L;
    protected Evaluation m_Evaluation;
    protected Classifier m_Template;
    protected Classifier m_Model;
    protected MetaData m_RunInformation;
    protected int[] m_OriginalIndices;
    protected SpreadSheet m_AdditionalAttributes;

    public ResultItem(Classifier template, Instances header) {
        super(header);
        if (template == null) {
            throw new IllegalArgumentException("Template classifier cannot be null!");
        }
        this.m_Template = template;
    }

    @Override
    protected String createName() {
        String result = DateUtils.getTimeFormatterMsecs().format(this.m_Timestamp) + " - " + this.m_Template.getClass().getSimpleName();
        if (this.hasHeader()) {
            result = result + " - " + this.m_Header.classAttribute().name() + " of " + Shortening.shortenEnd((String)this.m_Header.relationName(), (int)30);
        }
        return result;
    }

    public void update(Evaluation evaluation, Classifier model) {
        this.update(evaluation, model, null);
    }

    public void update(Evaluation evaluation, Classifier model, MetaData runInfo) {
        this.update(evaluation, model, runInfo, null, null);
    }

    public void update(Evaluation evaluation, Classifier model, MetaData runInfo, int[] original, SpreadSheet additional) {
        this.m_Evaluation = evaluation;
        this.m_Model = model;
        this.m_RunInformation = runInfo;
        this.m_OriginalIndices = original;
        this.m_AdditionalAttributes = additional;
    }

    public boolean hasEvaluation() {
        return this.m_Evaluation != null;
    }

    public Evaluation getEvaluation() {
        return this.m_Evaluation;
    }

    public Classifier getTemplate() {
        return this.m_Template;
    }

    public boolean hasModel() {
        return this.m_Model != null;
    }

    public Classifier getModel() {
        return this.m_Model;
    }

    public boolean hasRunInformation() {
        return this.m_RunInformation != null;
    }

    public MetaData getRunInformation() {
        return this.m_RunInformation;
    }

    public boolean hasOriginalIndices() {
        return this.m_OriginalIndices != null;
    }

    public int[] getOriginalIndices() {
        return this.m_OriginalIndices;
    }

    public boolean hasAdditionalAttributes() {
        return this.m_AdditionalAttributes != null;
    }

    public SpreadSheet getAdditionalAttributes() {
        return this.m_AdditionalAttributes;
    }

    @Override
    public String toString() {
        String result = this.getName();
        result = result + ", evaluation=" + this.hasEvaluation() + ", template=" + this.getTemplate().getClass().getName() + ", model=" + this.hasModel() + ", header=" + this.hasHeader() + ", runInfo=" + this.hasRunInformation();
        return result;
    }
}

