/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.evaluation;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.evaluation.AbstractClassifierEvaluation;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instances;

public class BuildModel
extends AbstractClassifierEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_MODEL = "model";
    protected ParameterPanel m_PanelParameters;
    protected JComboBox<String> m_ComboBoxDatasets;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected FileChooserPanel m_PanelModel;

    public String globalInfo() {
        return "Builds a model on a training set and serializes it to disk.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = BuildModel.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new JComboBox<String>(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_PanelModel = new FileChooserPanel();
        this.m_PanelModel.setCurrentDirectory((File)new PlaceholderFile(props.getPath("Classify.ModelDirectory", "%c")));
        ExtensionFileFilter filter = ExtensionFileFilter.getModelFileFilter();
        this.m_PanelModel.addChoosableFileFilter((FileFilter)filter);
        this.m_PanelModel.setFileFilter((FileFilter)filter);
        this.m_PanelModel.setAcceptAllFileFilterUsed(true);
        this.m_PanelModel.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Model", (Component)this.m_PanelModel);
    }

    @Override
    public String getName() {
        return "Build model";
    }

    @Override
    public String canEvaluate(Classifier classifier) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        File file = (File)this.m_PanelModel.getCurrent();
        if (file.isDirectory()) {
            return "Model points to directory: " + file;
        }
        Instances data = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Capabilities caps = classifier.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Classifier cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Classifier cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Classifier classifier) throws Exception {
        Instances data = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(classifier, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Classifier classifier, ResultItem item) throws Exception {
        Classifier model = (Classifier)OptionUtils.shallowCopy((Object)classifier);
        String msg = this.canEvaluate(model);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate classifier!\n" + msg);
        }
        DataContainer dataCont = ((ClassifyTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        Instances header = new Instances(data, 0);
        ((ClassifyTab)this.getOwner()).logMessage("Using '" + dataCont.getID() + "/" + data.relationName() + "' to build " + OptionUtils.getCommandLine((Object)classifier));
        model.buildClassifier(data);
        ((ClassifyTab)this.getOwner()).logMessage("Built model on '" + dataCont.getID() + "/" + data.relationName() + "' using " + OptionUtils.getCommandLine((Object)classifier));
        SerializationHelper.writeAll((String)((File)this.m_PanelModel.getCurrent()).getAbsolutePath(), (Object[])new Object[]{model, header});
        ((ClassifyTab)this.getOwner()).logMessage("Saved model built on '" + dataCont.getID() + "/" + data.relationName() + "' to " + ((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        MetaData runInfo = new MetaData();
        runInfo.add("Classifier", (Object)OptionUtils.getCommandLine((Object)classifier));
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        runInfo.add("Class attribute", (Object)data.classAttribute().name());
        runInfo.add("Model file", (Object)((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        this.addObjectSize(runInfo, "Model size", model);
        item.update(null, model, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClassifyTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClassifyTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClassifyTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        ((ClassifyTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize() {
        Map<String, Object> result = super.serialize();
        result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        result.put(KEY_MODEL, ((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex((Integer)data.get(KEY_DATASET));
        }
        if (data.containsKey(KEY_MODEL)) {
            this.m_PanelModel.setCurrent((File)new PlaceholderFile((String)data.get(KEY_MODEL)));
        }
    }
}

